/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.gems.item.ReturnHomeCharmItem;
import net.silentchaos512.gems.item.TeleporterLinkerItem;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.util.TeleportUtil;
import net.silentchaos512.lib.util.DimPos;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class GemTeleporterTileEntity
extends TileEntity {
    private static final Marker MARKER = MarkerManager.getMarker((String)"GemTeleporterTileEntity");
    private DimPos destination = null;
    private boolean isAnchor;

    public GemTeleporterTileEntity() {
        this(false);
    }

    public GemTeleporterTileEntity(boolean isAnchor) {
        super(GemsTileEntities.TELEPORTER.type());
        this.isAnchor = isAnchor;
    }

    public DimPos getDestination() {
        return this.destination;
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        this.tryReadDestination(tags);
        this.isAnchor = tags.func_74767_n("IsAnchor");
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        if (this.isDestinationSet()) {
            this.destination.write(tags);
        }
        tags.func_74757_a("IsAnchor", this.isAnchor);
        return tags;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tags = this.func_189517_E_();
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tags);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        if (this.isDestinationSet()) {
            this.destination.write(tags);
        }
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.tryReadDestination(packet.func_148857_g());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.tryReadDestination(tag);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private void tryReadDestination(CompoundNBT tag) {
        DimPos dimPos = DimPos.read((CompoundNBT)tag);
        if (!dimPos.equals((Object)DimPos.ZERO)) {
            this.destination = dimPos;
        }
    }

    public boolean interact(PlayerEntity player, ItemStack heldItem, Hand hand) {
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == TeleporterLinkerItem.INSTANCE.get()) {
            return GemTeleporterTileEntity.linkTeleporters(player, this.field_145850_b, this.field_174879_c, heldItem, hand);
        }
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ReturnHomeCharmItem) {
            return this.linkReturnHomeCharm(player, this.field_145850_b, this.field_174879_c, heldItem, hand);
        }
        if (this.isAnchor) {
            return false;
        }
        return this.tryTeleport((Entity)player, true);
    }

    public boolean tryTeleport(Entity entity, boolean playSfx) {
        if (!this.isDestinationSet()) {
            GemTeleporterTileEntity.sendMessage((ICommandSource)entity, "noDestination");
            return true;
        }
        if (!this.isDestinationSane(entity)) {
            GemTeleporterTileEntity.sendMessage((ICommandSource)entity, "notSane");
            return true;
        }
        if (!this.isDestinationSafe(entity)) {
            GemTeleporterTileEntity.sendMessage((ICommandSource)entity, "notSafe");
            return true;
        }
        if (!this.isDestinationAllowedIfDumb(entity)) {
            GemTeleporterTileEntity.sendMessage((ICommandSource)entity, "noReceiver");
            return true;
        }
        int chaosGenerated = this.getChaosGenerated(entity);
        if (this.teleportEntityToDestination(entity) && chaosGenerated > 0) {
            GemTeleporterTileEntity.generateChaos(entity, chaosGenerated);
        }
        if (playSfx) {
            this.playSound();
        }
        return true;
    }

    public void playSound() {
        float pitch = 0.7f + 0.3f * SilentGems.random.nextFloat();
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, pitch);
        this.field_145850_b.func_184133_a(null, this.destination.getPos(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    private static void sendMessage(ICommandSource entity, String key) {
        if (entity instanceof PlayerEntity) {
            TranslationTextComponent text = new TranslationTextComponent("teleporter.silentgems." + key, new Object[0]);
            entity.func_145747_a((ITextComponent)text);
        }
    }

    private boolean linkReturnHomeCharm(PlayerEntity player, World world, BlockPos pos, ItemStack heldItem, Hand hand) {
        Gems charmGem;
        Gems teleporterGem;
        Block block;
        if (world.field_72995_K) {
            return true;
        }
        if (this.isAnchor && !((Boolean)GemsConfig.COMMON.returnHomeAllowAnchors.get()).booleanValue()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("teleporter.silentgems.anchorBanned", new Object[0]));
            return false;
        }
        if (!this.isAnchor && ((Boolean)GemsConfig.COMMON.returnHomeMatchGems.get()).booleanValue() && (block = world.func_180495_p(pos).func_177230_c()) instanceof GemTeleporterBlock && heldItem.func_77973_b() instanceof ReturnHomeCharmItem && (teleporterGem = ((GemTeleporterBlock)block).getGem()) != (charmGem = ((ReturnHomeCharmItem)heldItem.func_77973_b()).getGem())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("teleporter.silentgems.gemsMustMatch", new Object[0]));
            return false;
        }
        DimPos position = DimPos.of((BlockPos)pos, (int)player.field_71093_bK.func_186068_a());
        position.write(heldItem.func_196082_o());
        GemTeleporterTileEntity.sendMessage((ICommandSource)player, "returnHomeBound");
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, heldItem);
        }
        return true;
    }

    private static boolean linkTeleporters(PlayerEntity player, World world, BlockPos pos, ItemStack heldItem, Hand hand) {
        if (world.field_72995_K) {
            return true;
        }
        if (heldItem.func_190926_b() || heldItem.func_77973_b() != TeleporterLinkerItem.INSTANCE.get()) {
            SilentGems.LOGGER.warn("GemTeleporterTileEntity.linkTeleporters: heldItem is not a linker?");
            return false;
        }
        if (TeleporterLinkerItem.isLinked(heldItem)) {
            DimPos position1 = TeleporterLinkerItem.getLinkedPosition(heldItem);
            DimPos position2 = DimPos.of((BlockPos)pos, (int)player.field_71093_bK.func_186068_a());
            if (DimPos.ZERO.equals((Object)position1)) {
                SilentGems.LOGGER.warn("Teleporter linker tried to link with no position set?");
                return true;
            }
            GemTeleporterTileEntity tile1 = GemTeleporterTileEntity.getTeleporterAt(player, position1);
            GemTeleporterTileEntity tile2 = GemTeleporterTileEntity.getTeleporterAt(player, position2);
            if (tile1 == null || tile2 == null) {
                GemTeleporterTileEntity.sendMessage((ICommandSource)player, "linkFail");
                SilentGems.LOGGER.warn("Could not find teleporter when linking:");
                SilentGems.LOGGER.warn("Teleporter1 @ {}", (Object)position1);
                SilentGems.LOGGER.warn("Teleporter1 @ {}", (Object)position2);
                TeleporterLinkerItem.setLinked(heldItem, false);
                return false;
            }
            tile1.destination = position2;
            tile2.destination = position1;
            SilentGems.LOGGER.debug("Teleporter1: {}", (Object)tile1.destination);
            SilentGems.LOGGER.debug("Teleporter2: {}", (Object)tile2.destination);
            TeleporterLinkerItem.setLinked(heldItem, false);
            tile1.func_70296_d();
            tile2.func_70296_d();
            GemTeleporterTileEntity.sendMessage((ICommandSource)player, "linkSuccess");
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, heldItem);
            }
        } else {
            TeleporterLinkerItem.setLinkedPosition(heldItem, DimPos.of((BlockPos)pos, (int)player.field_71093_bK.func_186068_a()));
            TeleporterLinkerItem.setLinked(heldItem, true);
            GemTeleporterTileEntity.sendMessage((ICommandSource)player, "linkStart");
        }
        return true;
    }

    @Nullable
    private static GemTeleporterTileEntity getTeleporterAt(PlayerEntity player, DimPos pos) {
        ServerWorld world = GemTeleporterTileEntity.getServerWorld(player, pos);
        if (world == null) {
            return null;
        }
        return (GemTeleporterTileEntity)world.func_175625_s(pos.getPos());
    }

    @Nullable
    private static ServerWorld getServerWorld(PlayerEntity player, DimPos pos) {
        MinecraftServer server = player.func_184102_h();
        if (server == null) {
            return null;
        }
        DimensionType dimensionType = DimensionType.func_186069_a((int)pos.getDimension());
        if (dimensionType == null) {
            return null;
        }
        return server.func_71218_a(dimensionType);
    }

    private int getChaosGenerated(Entity entity) {
        return Chaos.getChaosGeneratedByTeleport(entity, this.destination);
    }

    private static void generateChaos(Entity entity, int amount) {
        if (entity instanceof PlayerEntity) {
            Chaos.generate((PlayerEntity)entity, amount, true);
        } else {
            Chaos.generate((ICapabilityProvider)entity.field_70170_p, amount, entity.func_180425_c());
        }
    }

    private boolean isDestinationSafe(@Nullable Entity entity) {
        if (entity == null || !this.isDestinationSet()) {
            return true;
        }
        return TeleportUtil.isDestinationSafe(entity, this.destination);
    }

    private boolean isDestinationSane(@Nullable Entity entity) {
        if (entity == null || !this.isDestinationSet()) {
            return false;
        }
        return this.destination.getY() >= 0 && this.destination.getY() < 256;
    }

    private boolean isDestinationAllowedIfDumb(Entity player) {
        return true;
    }

    private boolean isDestinationSet() {
        return this.destination != null && !DimPos.ZERO.equals((Object)this.destination);
    }

    private boolean teleportEntityToDestination(Entity entity) {
        if (!this.isDestinationSet()) {
            return false;
        }
        TeleportUtil.teleport(entity, this.destination);
        return true;
    }
}

