/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.tokenenchanter;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterContainer;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.crafting.tokenenchanter.TokenEnchanterRecipe;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;

public class TokenEnchanterTileEntity
extends LockableSidedInventoryTileEntity
implements IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    static final int INVENTORY_SIZE = 8;
    private static final int[] SLOTS_INPUT = IntStream.range(0, 7).toArray();
    private static final int[] SLOTS_OUTPUT = new int[]{7};
    private static final int[] SLOTS_ALL = IntStream.range(0, 8).toArray();
    @SyncVariable(name="Progress")
    private int progress;
    @SyncVariable(name="ProcessTime")
    private int processTime;
    @SyncVariable(name="ChaosGenerated")
    private int chaosGenerated;
    private int chaosBuffer;
    private final Map<ResourceLocation, Integer> recipeUsedCount = new HashMap<ResourceLocation, Integer>();
    final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TokenEnchanterTileEntity.this.progress;
                }
                case 1: {
                    return TokenEnchanterTileEntity.this.processTime;
                }
                case 2: {
                    return TokenEnchanterTileEntity.this.chaosGenerated;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TokenEnchanterTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    TokenEnchanterTileEntity.this.processTime = value;
                    break;
                }
                case 2: {
                    TokenEnchanterTileEntity.this.chaosGenerated = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public TokenEnchanterTileEntity() {
        super(GemsTileEntities.TOKEN_ENCHANTER.type(), 8);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        TokenEnchanterRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(TokenEnchanterRecipe.RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
        if (recipe != null && this.hasRoomInOutput(recipe)) {
            ++this.progress;
            this.chaosGenerated = recipe.getChaosGenerated();
            this.processTime = recipe.getProcessTime();
            this.chaosBuffer += this.chaosGenerated;
            if (this.progress >= this.processTime) {
                this.placeResultInOutput(recipe);
                recipe.consumeIngredients((IInventory)this);
                this.progress = 0;
            }
            this.sendUpdate();
        } else {
            this.setNeutralState();
        }
        if (this.chaosBuffer > 0 && this.field_145850_b.func_82737_E() % 20L == 0L) {
            Chaos.generate((ICapabilityProvider)this.field_145850_b, this.chaosBuffer, this.field_174879_c);
            this.chaosBuffer = 0;
        }
    }

    private void sendUpdate() {
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private void setNeutralState() {
        boolean update = false;
        if (this.progress > 0) {
            this.progress = 0;
            update = true;
        }
        if (this.chaosGenerated > 0) {
            this.chaosGenerated = 0;
            update = true;
        }
        if (update) {
            this.sendUpdate();
        }
    }

    private boolean hasRoomInOutput(TokenEnchanterRecipe recipe) {
        ItemStack output = this.func_70301_a(7);
        return output.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)recipe.getResult());
    }

    private void placeResultInOutput(TokenEnchanterRecipe recipe) {
        ItemStack output = this.func_70301_a(7);
        if (output.func_190926_b()) {
            this.func_70299_a(7, recipe.getResult().func_77946_l());
        } else {
            output.func_190920_e(output.func_190916_E() + recipe.getResult().func_190916_E());
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgems.token_enchanter", new Object[0]);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new TokenEnchanterContainer(p_213906_1_, p_213906_2_, this);
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return SLOTS_INPUT;
            }
            case DOWN: {
                return SLOTS_ALL;
            }
        }
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index < 7;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 7;
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack stack : this.items) {
            helper.func_194112_a(stack);
        }
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.recipeUsedCount.compute(recipe.func_199560_c(), (id, count) -> 1 + (count == null ? 0 : count));
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getChaosGenerated() {
        return this.chaosGenerated;
    }
}

