/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.urn;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.SoulUrnTileEntity;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsSounds;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.urn.LidState;
import net.silentchaos512.gems.lib.urn.UrnHelper;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.client.key.InputUtils;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.Lazy;

public class SoulUrnBlock
extends ContainerBlock {
    public static final Lazy<SoulUrnBlock> INSTANCE = Lazy.of(SoulUrnBlock::new);
    private static final VoxelShape SHAPE_CLOSED = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_OPEN = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    static final EnumProperty<LidState> LID = EnumProperty.func_177709_a((String)"lid", LidState.class);
    private static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public SoulUrnBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(5.0f, 40.0f));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.SOUTH)).func_206870_a(LID, (Comparable)((Object)LidState.CLOSED)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, LID});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState currentState;
        if (context.func_196012_c() && (currentState = context.func_195991_k().func_180495_p(context.func_195995_a())).func_177230_c() == this) {
            return SoulUrnBlock.toggleLid(currentState);
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new SoulUrnTileEntity();
    }

    public ItemStack getStack(int color, @Nullable Gems gem) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (color != 9985861) {
            UrnHelper.setClayColor(stack, color);
        }
        if (gem != null) {
            UrnHelper.setGem(stack, gem);
        }
        return stack;
    }

    private static BlockState toggleLid(BlockState state) {
        LidState lid = (LidState)((Object)state.func_177229_b(LID));
        if (lid == LidState.NO_LID) {
            return state;
        }
        return (BlockState)state.func_206870_a(LID, (Comparable)((Object)(lid == LidState.CLOSED ? LidState.OPEN : LidState.CLOSED)));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SoulUrnTileEntity) {
            SoulUrnTileEntity soulUrn = (SoulUrnTileEntity)tile;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !soulUrn.func_191420_l()) {
                ItemStack itemstack = this.getStack(soulUrn.getColor(), soulUrn.getGem());
                CompoundNBT tags = soulUrn.saveToNBT(new CompoundNBT());
                if (!tags.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", (INBT)tags);
                }
                if (soulUrn.func_145818_k_()) {
                    itemstack.func_200302_a(soulUrn.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                soulUrn.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof SoulUrnTileEntity) {
            SoulUrnTileEntity soulUrn = (SoulUrnTileEntity)tile;
            builder = builder.func_216017_a(ShulkerBoxBlock.field_220169_b, (arg_0, arg_1) -> SoulUrnBlock.lambda$getDrops$0((IInventory)soulUrn, arg_0, arg_1));
        }
        return super.func_220076_a(state, builder);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            LidState lid = (LidState)((Object)state.func_177229_b(LID));
            if (lid != LidState.NO_LID && (player.func_70093_af() || !lid.isOpen())) {
                worldIn.func_180501_a(pos, SoulUrnBlock.toggleLid(state), 2);
                GemsSounds.SOUL_URN_LID.play((IWorld)worldIn, pos);
            } else {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof SoulUrnTileEntity) {
                    player.func_213829_a((INamedContainerProvider)tile);
                    GemsSounds.SOUL_URN_OPEN.play((IWorld)worldIn, pos);
                }
            }
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction side = placer != null ? placer.func_174811_aO().func_176734_d() : Direction.SOUTH;
        LidState lid = LidState.fromItem(stack);
        BlockState newState = (BlockState)((BlockState)state.func_206870_a((IProperty)FACING, (Comparable)side)).func_206870_a(LID, (Comparable)((Object)lid));
        worldIn.func_180501_a(pos, newState, 2);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SoulUrnTileEntity) {
            SoulUrnTileEntity tileSoulUrn = (SoulUrnTileEntity)tile;
            if (stack.func_82837_s()) {
                tileSoulUrn.func_213903_a(stack.func_200301_q());
            }
            tileSoulUrn.loadFromNBT(stack.func_190925_c("BlockEntityTag"));
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof SoulUrnTileEntity) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        CompoundNBT tag;
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        SoulUrnTileEntity tileSoulUrn = (SoulUrnTileEntity)world.func_175625_s(pos);
        if (tileSoulUrn != null && !(tag = tileSoulUrn.saveToNBT(new CompoundNBT())).isEmpty()) {
            stack.func_77983_a("BlockEntityInfo", (INBT)tag);
        }
        return stack;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_220060_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((LidState)((Object)state.func_177229_b(LID))).isOpen() ? SHAPE_OPEN : SHAPE_CLOSED;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public static int getBlockColor(BlockState state, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos, int tintIndex) {
        Gems gem;
        TileEntity tile;
        if (tintIndex == 0) {
            TileEntity tile2;
            if (world != null && pos != null && (tile2 = world.func_175625_s(pos)) instanceof SoulUrnTileEntity) {
                return ((SoulUrnTileEntity)tile2).getColor();
            }
            return 9985861;
        }
        if (tintIndex == 1 && world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof SoulUrnTileEntity && (gem = ((SoulUrnTileEntity)tile).getGem()) != null) {
            return gem.getColor();
        }
        return 0xFFFFFF;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return UrnHelper.getClayColor(stack);
        }
        if (tintIndex == 1) {
            Gems gem = UrnHelper.getGem(stack);
            return gem != null ? gem.getColor() : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int color = UrnHelper.getClayColor(stack);
        Gems gem = UrnHelper.getGem(stack);
        tooltip.add(color != 9985861 ? SoulUrnBlock.translate("color", Color.format((int)color)) : SoulUrnBlock.translate("color", SoulUrnBlock.translate("color.uncolored", new Object[0])));
        if (gem != null) {
            tooltip.add(SoulUrnBlock.translate("gem", gem.getItemStack().func_200301_q()));
        }
        if (InputUtils.isControlDown()) {
            tooltip.add(SoulUrnBlock.translate("upgrades", new Object[0]).func_211708_a(TextFormatting.YELLOW));
            NonNullList<UrnUpgrade> upgrades = UrnUpgrade.ListHelper.load(stack);
            for (UrnUpgrade upgrade : upgrades) {
                tooltip.add(SoulUrnBlock.translate("upgrade_list", upgrade.getDisplayName()));
            }
        } else {
            ITextComponent pressCtrl = new TranslationTextComponent("misc.silentgems.pressCtrl", new Object[0]).func_211708_a(TextFormatting.DARK_GRAY);
            tooltip.add(SoulUrnBlock.translate("upgrades", pressCtrl).func_211708_a(TextFormatting.YELLOW));
            SoulUrnBlock.addInventoryInformation(stack, worldIn, tooltip, flagIn);
        }
    }

    private static void addInventoryInformation(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tags = stack.func_179543_a("BlockEntityTag");
        if (tags != null) {
            if (tags.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????"));
            }
            if (tags.func_150297_b("Items", 9)) {
                NonNullList list = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)tags, (NonNullList)list);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : list) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    ITextComponent text = itemstack.func_200301_q().func_212638_h();
                    text.func_150258_a(" x").func_150258_a(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add(text);
                }
                if (j - i > 0) {
                    tooltip.add(new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_211708_a(TextFormatting.ITALIC));
                }
            }
        }
    }

    private static ITextComponent translate(String key, Object ... args) {
        return new TranslationTextComponent("block.silentgems.soul_urn." + key, args);
    }

    private static /* synthetic */ void lambda$getDrops$0(IInventory soulUrn, LootContext context, Consumer consumer) {
        for (int i = 0; i < soulUrn.func_70302_i_(); ++i) {
            consumer.accept(soulUrn.func_70301_a(i));
        }
    }

    public static class SoulUrnBlockItem
    extends BlockItem {
        private static List<ItemStack> SAMPLE_SUB_ITEMS;
        private final SoulUrnBlock blockSoulUrn;

        public SoulUrnBlockItem(SoulUrnBlock block) {
            super((Block)block, new Item.Properties().func_200917_a(1).func_200916_a(GemsItemGroups.BLOCKS));
            this.blockSoulUrn = block;
            this.func_185043_a(SilentGems.getId("lidless"), (stack, world, entity) -> UrnHelper.hasLid(stack) ? 0.0f : 1.0f);
        }

        public ActionResultType func_195939_a(ItemUseContext context) {
            BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
            if (state.func_177230_c() == Blocks.field_150383_bp) {
                int waterLevel = (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a);
                if (waterLevel > 0) {
                    UrnHelper.setClayColor(context.func_195996_i(), 9985861);
                    ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(context.func_195991_k(), context.func_195995_a(), state, waterLevel - 1);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            return super.func_195939_a(context);
        }

        public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
            super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        }

        public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
            if (!this.func_194125_a(group)) {
                return;
            }
            if (SAMPLE_SUB_ITEMS == null) {
                SAMPLE_SUB_ITEMS = new ArrayList<ItemStack>();
                SAMPLE_SUB_ITEMS.add(this.blockSoulUrn.getStack(9985861, Gems.selectRandom()));
                for (DyeColor color : DyeColor.values()) {
                    SAMPLE_SUB_ITEMS.add(this.blockSoulUrn.getStack(color.func_196057_c(), Gems.selectRandom()));
                }
            }
            items.addAll(SAMPLE_SUB_ITEMS);
        }
    }
}

