/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.urn;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.silentchaos512.gems.block.urn.SoulUrnBlock;
import net.silentchaos512.gems.block.urn.SoulUrnContainer;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.gems.item.SoulUrnUpgrades;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.urn.LidState;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;

public class SoulUrnTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
ISidedInventory,
IHopper {
    private static final int INVENTORY_ROWS_BASE = 6;
    private static final int INVENTORY_ROWS_UPGRADED = 6;
    private static final int[] SLOTS_BASE = IntStream.range(0, 54).toArray();
    private static final int[] SLOTS_UPGRADED = IntStream.range(0, 54).toArray();
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private NonNullList<ItemStack> items;
    private final NonNullList<UrnUpgrade> upgrades = NonNullList.func_191196_a();
    private int color;
    private Gems gem = null;
    private boolean sizeUpgrade;
    private boolean lidded = true;
    private int transferCooldown = -1;

    public SoulUrnTileEntity() {
        super(GemsTileEntities.SOUL_URN.type());
        this.items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    }

    private void setUpgrades(Collection<UrnUpgrade> list) {
        this.upgrades.clear();
        this.upgrades.addAll(list);
        this.sizeUpgrade = UrnUpgrade.ListHelper.contains(this.upgrades, SoulUrnUpgrades.EXTRA_STORAGE);
        int inventoryRows = this.sizeUpgrade ? 6 : 6;
        NonNullList newList = NonNullList.func_191197_a((int)(9 * inventoryRows), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < newList.size() && i < this.items.size(); ++i) {
            newList.set(i, this.items.get(i));
        }
        this.items = newList;
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public Gems getGem() {
        return this.gem;
    }

    public int[] func_180463_a(Direction side) {
        return this.sizeUpgrade ? SLOTS_UPGRADED : SLOTS_BASE;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        Block block = Block.func_149634_a((Item)itemStackIn.func_77973_b());
        return !(block instanceof SoulUrnBlock) && !(block instanceof ShulkerBoxBlock);
    }

    public boolean tryAddItemToInventory(ItemStack stack) {
        if (this.isFull() || !this.func_180462_a(0, stack, Direction.UP)) {
            return false;
        }
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack stackInSlot = this.func_70301_a(slot);
            if (!stackInSlot.func_190926_b() && !stackInSlot.func_77969_a(stack)) continue;
            if (!stackInSlot.func_190926_b()) {
                int amountCanFit = Math.min(stack.func_190916_E(), stackInSlot.func_77976_d() - stackInSlot.func_190916_E());
                if (amountCanFit <= 0) continue;
                stackInSlot.func_190920_e(stackInSlot.func_190916_E() + amountCanFit);
                stack.func_190920_e(stack.func_190916_E() - amountCanFit);
                this.func_70299_a(slot, stackInSlot);
                return true;
            }
            this.func_70299_a(slot, stack.func_77946_l());
            stack.func_190920_e(0);
            return true;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isFull() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgems.soul_urn", new Object[0]);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new SoulUrnContainer(p_213906_1_, p_213906_2_, this);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        LidState lid = (LidState)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(SoulUrnBlock.LID));
        SoulUrnState state = new SoulUrnState(this, lid);
        for (UrnUpgrade upgrade : this.upgrades) {
            upgrade.tickTile(state, this.field_145850_b, this.field_174879_c);
        }
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        }
        if (lid.isOpen() && !this.isOnTransferCooldown()) {
            this.transferCooldown = 0;
            this.updateHopper(() -> HopperTileEntity.func_145891_a((IHopper)this));
        }
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    private boolean updateHopper(Supplier<Boolean> booleanSupplier) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown()) {
                boolean flag = false;
                if (!this.isFull()) {
                    flag |= booleanSupplier.get().booleanValue();
                }
                if (flag) {
                    this.transferCooldown = 8;
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void func_145839_a(CompoundNBT compound) {
        this.loadFromNBT(compound);
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNBT(compound);
    }

    void loadFromNBT(CompoundNBT compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.setUpgrades((Collection<UrnUpgrade>)UrnUpgrade.ListHelper.load(compound));
        if (!this.func_184283_b(compound) && compound.func_74764_b("Items")) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        }
        this.loadColorFromNBT(compound);
        this.loadGemFromNBT(compound);
        this.lidded = !compound.func_74764_b("Lidded") || compound.func_74767_n("Lidded");
    }

    CompoundNBT saveToNBT(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)false);
        }
        if (this.color != 9985861) {
            compound.func_74768_a("Color", this.color);
        }
        if (this.gem != null) {
            compound.func_74778_a("Gem", this.gem.func_176610_l());
        }
        compound.func_74757_a("Lidded", this.lidded);
        UrnUpgrade.ListHelper.save(this.upgrades, compound);
        return compound;
    }

    private void loadColorFromNBT(CompoundNBT compound) {
        if (compound.func_74764_b("Color")) {
            this.color = compound.func_74762_e("Color");
        }
    }

    private void loadGemFromNBT(CompoundNBT compound) {
        if (compound.func_74764_b("Gem")) {
            this.gem = Gems.fromName(compound.func_74779_i("Gem"));
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        if (this.color != 9985861) {
            tags.func_74768_a("Color", this.color);
        }
        if (this.gem != null) {
            tags.func_74778_a("Gem", this.gem.func_176610_l());
        }
        UrnUpgrade.ListHelper.save(this.upgrades, tags);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT tags = pkt.func_148857_g();
        this.loadColorFromNBT(tags);
        this.loadGemFromNBT(tags);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public static final class SoulUrnState {
        private final SoulUrnTileEntity tileEntity;
        private final LidState lidState;
        private boolean itemsAbsorbed = false;

        private SoulUrnState(SoulUrnTileEntity tile, LidState lidState) {
            this.tileEntity = tile;
            this.lidState = lidState;
        }

        public SoulUrnTileEntity getTileEntity() {
            return this.tileEntity;
        }

        public LidState getLidState() {
            return this.lidState;
        }

        public boolean getItemsAbsorbed() {
            return this.itemsAbsorbed;
        }

        public void setItemsAbsorbed(boolean value) {
            this.itemsAbsorbed = value;
        }
    }
}

