/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.chaos;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.gems.api.chaos.IChaosSource;
import net.silentchaos512.gems.block.pedestal.PedestalTileEntity;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.ChaosOrbItem;
import net.silentchaos512.lib.util.DimPos;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.lib.util.WorldUtils;

public final class Chaos {
    private static final int DISSIPATION_SCALE = 20;
    static final int ENTITY_TO_WORLD_RATE = 50;
    private static final int EQUILIBRIUM_BASE = 150000;
    private static final int EQUILIBRIUM_VARIATION = 100000;
    private static final int EQUILIBRIUM_CYCLE_LENGTH = TimeUtils.ticksFromHours((float)4.0f);
    private static final double EQUILIBRIUM_CYCLE_CONSTANT = Math.PI * 2 / (double)EQUILIBRIUM_CYCLE_LENGTH;
    private static final int PEDESTAL_SEARCH_RADIUS = 6;

    private Chaos() {
        throw new IllegalAccessError("Utility class");
    }

    public static void generate(PlayerEntity player, int amount, boolean allowOrbs) {
        if (amount == 0) {
            return;
        }
        int amountLeft = amount;
        if (allowOrbs) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ChaosOrbItem)) continue;
                amountLeft = ChaosOrbItem.absorbChaos((LivingEntity)player, stack, amountLeft);
                break;
            }
        }
        Chaos.generate((ICapabilityProvider)player, amountLeft, player.func_180425_c(), false);
    }

    public static void generate(ICapabilityProvider obj, int amount, BlockPos pos) {
        Chaos.generate(obj, amount, pos, true);
    }

    public static void generate(ICapabilityProvider obj, int amount, BlockPos pos, boolean sendToPedestals) {
        int remainder;
        World world;
        Collection<PedestalTileEntity> pedestals;
        if (amount == 0) {
            return;
        }
        int amountLeft = amount;
        if (sendToPedestals && obj instanceof World && !(pedestals = Chaos.getNearbyPedestalsWithOrbs(world = (World)obj, pos)).isEmpty()) {
            int amountPerOrb = amount / pedestals.size();
            amountLeft = 0;
            for (PedestalTileEntity pedestal : pedestals) {
                ItemStack stack = pedestal.getItem();
                amountLeft += ChaosOrbItem.absorbChaos((IWorld)world, pedestal.func_174877_v(), stack, amountPerOrb);
                pedestal.setItem(stack);
            }
        }
        if ((remainder = amountLeft) > 0) {
            obj.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> source.addChaos(remainder));
        }
    }

    public static void dissipate(PlayerEntity player, int amount) {
        if (amount <= 0) {
            return;
        }
        IChaosSource source = (IChaosSource)player.getCapability(ChaosSourceCapability.INSTANCE).orElseThrow(IllegalStateException::new);
        int amountLeft = source.dissipateChaos(amount);
        Chaos.dissipate(player.field_70170_p, amountLeft);
    }

    public static void dissipate(World world, int amount) {
        if (amount <= 0) {
            return;
        }
        IChaosSource worldSource = (IChaosSource)world.getCapability(ChaosSourceCapability.INSTANCE).orElseThrow(IllegalStateException::new);
        int amountLeft = worldSource.dissipateChaos(amount);
        if (amountLeft <= 0) {
            return;
        }
        List players = world.func_217369_A();
        int amountPerPlayer = amountLeft / players.size();
        for (PlayerEntity player : players) {
            player.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> source.dissipateChaos(amountPerPlayer));
        }
    }

    public static int getDissipationRate(World world) {
        return world.func_217369_A().size() * 20;
    }

    public static int getEquilibriumPoint(World world) {
        long time = world.func_82737_E();
        return (int)(150000.0 + 100000.0 * Math.cos(EQUILIBRIUM_CYCLE_CONSTANT * (double)time));
    }

    public static int getChaos(ICapabilityProvider provider) {
        LazyOptional optional = provider.getCapability(ChaosSourceCapability.INSTANCE);
        return optional.isPresent() ? ((IChaosSource)optional.orElseGet(ChaosSourceCapability::new)).getChaos() : 0;
    }

    private static Collection<PedestalTileEntity> getNearbyPedestalsWithOrbs(World world, BlockPos pos) {
        int xMin = pos.func_177958_n() - 6;
        int xMax = pos.func_177958_n() + 6;
        int yMin = pos.func_177956_o() - 6;
        int yMax = pos.func_177956_o() + 6;
        int zMin = pos.func_177952_p() - 6;
        int zMax = pos.func_177952_p() + 6;
        return WorldUtils.getBlocks((World)world, (int)xMin, (int)yMin, (int)zMin, (int)xMax, (int)yMax, (int)zMax, (w, p) -> {
            TileEntity te = w.func_175625_s(p);
            if (te instanceof PedestalTileEntity && ((PedestalTileEntity)te).getItem().func_77973_b() instanceof ChaosOrbItem) {
                return Optional.of((PedestalTileEntity)te);
            }
            return Optional.empty();
        }).values();
    }

    public static int getChaosGeneratedByTeleport(Entity entity, DimPos destination) {
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return 0;
        }
        DimPos source = DimPos.of((BlockPos)entity.func_180425_c(), (int)entity.field_71093_bK.func_186068_a());
        return Chaos.getChaosGeneratedByTeleport(source, destination);
    }

    public static int getChaosGeneratedByTeleport(DimPos source, DimPos destination) {
        double z;
        if (source.getDimension() != destination.getDimension()) {
            return (Integer)GemsConfig.COMMON.teleporterChaosCrossDimension.get();
        }
        double x = source.getX() - destination.getX();
        double distance = Math.sqrt(x * x + (z = (double)(source.getZ() - destination.getZ())) * z);
        if (distance < (double)((Integer)GemsConfig.COMMON.teleporterFreeRange.get()).intValue()) {
            return 0;
        }
        return (int)((double)((Integer)GemsConfig.COMMON.teleporterChaosPerBlock.get()).intValue() * distance);
    }
}

