/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.chaos;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.chaos.ChaosEvent;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;
import net.silentchaos512.gems.world.spawner.WispSpawner;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ChaosEvents {
    private static final Map<ResourceLocation, ChaosEvent> EVENTS = new HashMap<ResourceLocation, ChaosEvent>();
    private static final Map<UUID, Map<ResourceLocation, Integer>> COOLDOWN_TIMERS = new HashMap<UUID, Map<ResourceLocation, Integer>>();
    private static final Marker MARKER = MarkerManager.getMarker((String)"ChaosEvents");
    private static final int MAX_CHAOS = 5000000;

    private ChaosEvents() {
        throw new IllegalAccessError("Utility class");
    }

    public static void addChaosEvent(ResourceLocation id, ChaosEvent event) {
        EVENTS.put(id, event);
    }

    static void tryChaosEvents(PlayerEntity player, World world, int chaos) {
        if (player == null || !player.func_70089_S()) {
            return;
        }
        Map cooldownTimers = COOLDOWN_TIMERS.computeIfAbsent(player.func_110124_au(), uuid -> new HashMap());
        EVENTS.forEach((id, event) -> {
            int cooldown = ChaosEvents.getAndDecrementTimer(id, cooldownTimers);
            if (cooldown <= 0 && event.tryActivate(player, chaos)) {
                SilentGems.LOGGER.info(MARKER, "Activate {} @ {}", id, (Object)player.func_195047_I_());
                cooldownTimers.put(id, event.getCooldownTime());
            }
        });
    }

    private static int getAndDecrementTimer(ResourceLocation id, Map<ResourceLocation, Integer> timers) {
        if (!timers.containsKey(id)) {
            return 0;
        }
        int time = timers.get(id) - 1;
        if (time <= 0) {
            timers.remove(id);
        } else {
            timers.put(id, time);
        }
        return time;
    }

    public static Collection<ResourceLocation> getEventIds() {
        return EVENTS.keySet();
    }

    public static void triggerEvent(ResourceLocation eventId, PlayerEntity player) {
        player.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            ChaosEvent event = EVENTS.get(eventId);
            if (event != null) {
                event.activate(player, source.getChaos());
            }
        });
    }

    private static boolean spawnLightningBolt(Entity entity, World world) {
        if (world instanceof ServerWorld && ChaosEvents.canSpawnLightningIn(world.field_73011_w.func_186058_p())) {
            double posX = entity.field_70165_t + (double)MathUtils.nextIntInclusive((int)-64, (int)64);
            double posZ = entity.field_70161_v + (double)MathUtils.nextIntInclusive((int)-64, (int)64);
            int height = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, (int)posX, (int)posZ);
            LightningBoltEntity bolt = new LightningBoltEntity(world, posX, (double)height, posZ, false);
            ((ServerWorld)world).func_217468_a(bolt);
            return true;
        }
        return false;
    }

    private static boolean canSpawnLightningIn(DimensionType dimensionType) {
        return dimensionType.func_186068_a() != DimensionType.field_223228_b_.func_186068_a() && dimensionType.func_186068_a() != DimensionType.field_223229_c_.func_186068_a();
    }

    private static boolean corruptBlocks(Entity entity, World world) {
        int posX = (int)entity.field_70165_t + MathUtils.nextIntInclusive((int)-128, (int)128);
        int posZ = (int)entity.field_70161_v + MathUtils.nextIntInclusive((int)-128, (int)128);
        int posY = 64 + MathUtils.nextIntInclusive((int)-32, (int)64);
        BlockPos pos = new BlockPos(posX, posY, posZ);
        boolean done = false;
        while (pos.func_177956_o() > 1 && !done) {
            BlockState state = world.func_180495_p(pos);
            for (CorruptedBlocks corruptedBlocks : CorruptedBlocks.values()) {
                if (!corruptedBlocks.canReplace(state.func_177230_c())) continue;
                ChaosEvents.makeCorruptedBlockCluster(world, pos, corruptedBlocks);
                done = true;
            }
            pos = pos.func_177977_b();
        }
        return done;
    }

    private static void makeCorruptedBlockCluster(World world, BlockPos pos, CorruptedBlocks corruptedBlock) {
        SilentGems.LOGGER.debug(MARKER, "corrupted cluster @ {}", (Object)pos);
        BlockState newState = corruptedBlock.asBlockState();
        world.func_180501_a(pos, newState, 3);
        for (int i = 0; i < 40; ++i) {
            BlockPos pos1 = new BlockPos(pos.func_177958_n() + (int)(1.5 * SilentGems.random.nextGaussian()), pos.func_177956_o() + (int)(1.5 * SilentGems.random.nextGaussian()), pos.func_177952_p() + (int)(1.5 * SilentGems.random.nextGaussian()));
            BlockState target = world.func_180495_p(pos1);
            if (!corruptedBlock.canReplace(target.func_177230_c())) continue;
            world.func_180501_a(pos1, newState, 3);
        }
    }

    private static boolean setThunderstorm(World world, int time) {
        if (!world.func_82736_K().func_223586_b(GameRules.field_223617_t) || world.func_72912_H().func_76061_m()) {
            return false;
        }
        world.func_72912_H().func_176142_i(0);
        world.func_72912_H().func_76080_g(time);
        world.func_72912_H().func_76090_f(time);
        world.func_72912_H().func_76084_b(true);
        world.func_72912_H().func_76069_a(true);
        return true;
    }

    public static List<String> getCooldownTimersDebugText(PlayerEntity player) {
        if (player == null || !COOLDOWN_TIMERS.containsKey(player.func_110124_au())) {
            return ImmutableList.of();
        }
        return COOLDOWN_TIMERS.get(player.func_110124_au()).entrySet().stream().map(entry -> entry.getKey() + ": " + entry.getValue()).collect(Collectors.toList());
    }

    static {
        ChaosEvents.addChaosEvent(SilentGems.getId("chaos_lightning"), new ChaosEvent(0.2f, 30, 250000, 5000000, 25000, (player, chaos) -> ChaosEvents.spawnLightningBolt((Entity)player, player.field_70170_p)));
        ChaosEvents.addChaosEvent(SilentGems.getId("corrupt_blocks"), new ChaosEvent(0.2f, 600, 750000, 5000000, 100000, (player, chaos) -> ChaosEvents.corruptBlocks((Entity)player, player.field_70170_p)));
        ChaosEvents.addChaosEvent(SilentGems.getId("spawn_chaos_wisps"), new ChaosEvent(0.1f, 600, 200000, 1250000, 20000, WispSpawner::spawnWisps));
        ChaosEvents.addChaosEvent(SilentGems.getId("thunderstorm"), new ChaosEvent(0.05f, 1200, 1000000, 5000000, 200000, (player, chaos) -> {
            int time = TimeUtils.ticksFromMinutes((float)MathUtils.nextIntInclusive((int)7, (int)15));
            return ChaosEvents.setThunderstorm(player.field_70170_p, time);
        }));
    }
}

