/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.chaos;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.gems.api.chaos.IChaosSource;

public class ChaosSourceCapability
implements IChaosSource,
ICapabilitySerializable<CompoundNBT> {
    @CapabilityInject(value=IChaosSource.class)
    public static Capability<IChaosSource> INSTANCE = null;
    public static ResourceLocation NAME = new ResourceLocation("silentgems", "chaos_source");
    private static final String NBT_CHAOS = "Chaos";
    private final LazyOptional<IChaosSource> holder = LazyOptional.of(() -> this);
    private int chaos;

    @Override
    public int getChaos() {
        return this.chaos;
    }

    @Override
    public void setChaos(int amount) {
        this.chaos = amount;
        if (this.chaos < 0) {
            this.chaos = 0;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(NBT_CHAOS, this.chaos);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.chaos = nbt.func_74762_e(NBT_CHAOS);
    }

    public static boolean canAttachTo(ICapabilityProvider obj) {
        return (obj instanceof PlayerEntity || obj instanceof World) && !obj.getCapability(INSTANCE).isPresent();
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IChaosSource.class, (Capability.IStorage)new Storage(), ChaosSourceCapability::new);
    }

    private static class Storage
    implements Capability.IStorage<IChaosSource> {
        private Storage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IChaosSource> capability, IChaosSource instance, Direction side) {
            if (instance instanceof ChaosSourceCapability) {
                return ((ChaosSourceCapability)instance).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void readNBT(Capability<IChaosSource> capability, IChaosSource instance, Direction side, INBT nbt) {
            if (instance instanceof ChaosSourceCapability) {
                ((ChaosSourceCapability)instance).deserializeNBT((CompoundNBT)nbt);
            }
        }
    }
}

