/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.entity.AbstractWispEntity;
import net.silentchaos512.utils.Color;

public class WispModel<T extends AbstractWispEntity>
extends EntityModel<T> {
    private final RendererModel[] satellites = new RendererModel[12];
    private final RendererModel mainBody;

    public WispModel() {
        for (int i = 0; i < this.satellites.length; ++i) {
            this.satellites[i] = new RendererModel((Model)this, 0, 16);
            this.satellites[i].func_78789_a(0.0f, 0.0f, 0.0f, 2, 2, 2);
        }
        this.mainBody = new RendererModel((Model)this, 0, 0);
        this.mainBody.func_78789_a(-4.0f, -1.0f, -4.0f, 8, 8, 8);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        Color color = ((AbstractWispEntity)((Object)entityIn)).getWispType().getColor();
        GlStateManager.color3f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
        this.setRotationAngles(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.mainBody.func_78785_a(scale);
        for (RendererModel model : this.satellites) {
            model.func_78785_a(scale);
        }
        GlStateManager.popMatrix();
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        float f = 0.7853982f + ageInTicks * (float)Math.PI * 0.03f;
        for (int i = 0; i < this.satellites.length; ++i) {
            this.satellites[i].field_78797_d = 2.0f + MathHelper.func_76134_b((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.satellites[i].field_78800_c = MathHelper.func_76134_b((float)f) * 7.0f;
            this.satellites[i].field_78798_e = MathHelper.func_76126_a((float)f) * 7.0f;
            f += 0.525f;
        }
        this.mainBody.field_78796_g = -ageInTicks * (float)Math.PI * -0.05f;
    }
}

