/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.silentchaos512.gems.chaos.ChaosEvents;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;

public final class ChaosCommand {
    private static final SuggestionProvider<CommandSource> EVENT_ID_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(ChaosEvents.getEventIds().stream(), (SuggestionsBuilder)builder);

    private ChaosCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"sg_chaos").requires(source -> source.func_197034_c(2));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ChaosCommand::runGet))).then(Commands.func_197057_a((String)"world").executes(ChaosCommand::runGetWorld))).executes(context -> ChaosCommand.runGetSingle((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ChaosCommand::runSet)))).then(Commands.func_197057_a((String)"world").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ChaosCommand::runSetWorld))));
        builder.then(Commands.func_197057_a((String)"trigger_event").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"event", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(EVENT_ID_SUGGESTIONS).executes(context -> {
            ChaosEvents.triggerEvent(ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"event"), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"target"));
            return 1;
        }))));
        dispatcher.register(builder);
    }

    private static int runGet(CommandContext<CommandSource> context) throws CommandSyntaxException {
        for (ServerPlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
            ChaosCommand.runGetSingle(context, player);
        }
        return 1;
    }

    private static int runGetSingle(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        player.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            String format = String.format("%,d", source.getChaos());
            ITextComponent text = ChaosCommand.translate("chaos.get", player.func_200200_C_(), format);
            ((CommandSource)context.getSource()).func_197030_a(text, true);
        });
        return 1;
    }

    private static int runGetWorld(CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        world.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            String format = String.format("%,d", source.getChaos());
            ITextComponent text = ChaosCommand.translate("chaos.get", "world", format);
            ((CommandSource)context.getSource()).func_197030_a(text, true);
        });
        return 1;
    }

    private static int runSet(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
            player.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
                source.setChaos(amount);
                String format = String.format("%,d", source.getChaos());
                ITextComponent text = ChaosCommand.translate("chaos.set", player.func_200200_C_(), format);
                ((CommandSource)context.getSource()).func_197030_a(text, true);
            });
        }
        return 1;
    }

    private static int runSetWorld(CommandContext<CommandSource> context) {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        world.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            source.setChaos(amount);
            String format = String.format("%,d", source.getChaos());
            ITextComponent text = ChaosCommand.translate("chaos.set", "world", format);
            ((CommandSource)context.getSource()).func_197030_a(text, true);
        });
        return 1;
    }

    private static ITextComponent translate(String key, Object ... params) {
        return new TranslationTextComponent("command.silentgems." + key, params);
    }
}

