/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.gear;

import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.compat.gear.SGearCompat;
import net.silentchaos512.gems.compat.gear.SGearGemsEvents;

public final class SGearProxy {
    private static boolean modLoaded = false;

    private SGearProxy() {
        throw new IllegalAccessError("Utility class");
    }

    public static void detectSilentGear() {
        modLoaded = ModList.get().isLoaded("silentgear");
        if (modLoaded) {
            SilentGems.LOGGER.info("Detected Silent Gear!");
            MinecraftForge.EVENT_BUS.register((Object)new SGearGemsEvents());
        }
    }

    public static boolean isLoaded() {
        return modLoaded;
    }

    public static String getGradeString(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.getGradeString(stack);
        }
        return "N/A";
    }

    public static int getPartTier(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.getPartTier(stack);
        }
        return -1;
    }

    public static boolean isMainPart(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.isMainPart(stack);
        }
        return false;
    }
}

