/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.flowerpot.LuminousFlowerPotBlock;
import net.silentchaos512.gems.block.supercharger.SuperchargerBlock;
import net.silentchaos512.gems.block.supercharger.SuperchargerPillarStructure;
import net.silentchaos512.gems.block.supercharger.SuperchargerScreen;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterBlock;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterScreen;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.compat.jei.SuperchargerPillarCategory;
import net.silentchaos512.gems.compat.jei.SuperchargingRecipeCategoryJei;
import net.silentchaos512.gems.compat.jei.TokenEnchanterRecipeCategoryJei;
import net.silentchaos512.gems.crafting.tokenenchanter.TokenEnchanterRecipe;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.gems.lib.soul.Soul;

@JeiPlugin
public class SilentGemsPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGems.getId("plugin/main");
    static final ResourceLocation SUPERCHARGER_PILLAR = SilentGems.getId("category/supercharger_pillar");
    static final ResourceLocation SUPERCHARGING = SilentGems.getId("category/supercharging");
    static final ResourceLocation TOKEN_ENCHANTING = SilentGems.getId("category/token_enchanting");
    static final ResourceLocation GUI_TEXTURE = SilentGems.getId("textures/gui/recipe_display.png");
    private static boolean initFailed = true;

    public static boolean hasInitFailed() {
        return initFailed;
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        initFailed = true;
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new TokenEnchanterRecipeCategoryJei(guiHelper)});
        if (SGearProxy.isLoaded()) {
            reg.addRecipeCategories(new IRecipeCategory[]{new SuperchargerPillarCategory(guiHelper), new SuperchargingRecipeCategoryJei(guiHelper)});
        }
        initFailed = false;
    }

    public void registerRecipes(IRecipeRegistration reg) {
        initFailed = true;
        reg.addRecipes(SilentGemsPlugin.getRecipesOfType(TokenEnchanterRecipe.RECIPE_TYPE), TOKEN_ENCHANTING);
        if (SGearProxy.isLoaded()) {
            reg.addRecipes((Collection)ImmutableList.of((Object)new SuperchargerPillarStructure(1, (Collection<Tag<Item>>)ImmutableList.of(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_CAP)), (Object)new SuperchargerPillarStructure(2, (Collection<Tag<Item>>)ImmutableList.of(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL2, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_CAP)), (Object)new SuperchargerPillarStructure(3, (Collection<Tag<Item>>)ImmutableList.of(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL3, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL3, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL2, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_CAP))), SUPERCHARGER_PILLAR);
            IntStream.rangeClosed(1, 3).forEach(tier -> reg.addRecipes((Collection)PartManager.getMains().stream().map(part -> new SuperchargingRecipeCategoryJei.Recipe((IGearPart)part, tier)).collect(Collectors.toList()), SUPERCHARGING));
        }
        SilentGemsPlugin.addInfoPage(reg, CraftingItems.ENDER_SLIMEBALL);
        SilentGemsPlugin.addInfoPage(reg, "glowrose", Arrays.stream(Gems.values()).map(gem -> new ItemStack((IItemProvider)gem.getGlowrose())));
        SilentGemsPlugin.addInfoPage(reg, (IItemProvider)LuminousFlowerPotBlock.INSTANCE.get());
        initFailed = false;
    }

    private static List<IRecipe<?>> getRecipesOfType(IRecipeType<?> recipeType) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == recipeType).collect(Collectors.toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SuperchargerBlock.INSTANCE.get()), new ResourceLocation[]{SUPERCHARGING, SUPERCHARGER_PILLAR});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TokenEnchanterBlock.INSTANCE.get()), new ResourceLocation[]{TOKEN_ENCHANTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(SuperchargerScreen.class, 79, 32, 24, 23, new ResourceLocation[]{SUPERCHARGING, SUPERCHARGER_PILLAR});
        reg.addRecipeClickArea(TokenEnchanterScreen.class, 102, 32, 24, 23, new ResourceLocation[]{TOKEN_ENCHANTING});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        initFailed = true;
        reg.registerSubtypeInterpreter((Item)EnchantmentTokenItem.INSTANCE.get(), stack -> {
            Enchantment enchantment = EnchantmentTokenItem.getSingleEnchantment(stack);
            return enchantment != null ? enchantment.func_77320_a() : "none";
        });
        reg.registerSubtypeInterpreter((Item)ChaosRuneItem.INSTANCE.get(), stack -> {
            IChaosBuff buff = ChaosRuneItem.getBuff(stack);
            return buff != null ? buff.getId().toString() : "none";
        });
        reg.registerSubtypeInterpreter((Item)SoulGemItem.INSTANCE.get(), stack -> {
            Soul soul = SoulGemItem.getSoul(stack);
            return soul != null ? soul.getId().toString() : "none";
        });
        initFailed = false;
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item) {
        String key = SilentGemsPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item, Stream<ItemStack> variants) {
        String key = SilentGemsPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, String itemName, Stream<ItemStack> variants) {
        String key = SilentGemsPlugin.getDescKey(SilentGems.getId(itemName));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{key});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

