/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gems.api.chaos.ChaosEmissionRate;
import net.silentchaos512.gems.block.supercharger.SuperchargerBlock;
import net.silentchaos512.gems.block.supercharger.SuperchargerTileEntity;
import net.silentchaos512.gems.compat.jei.SilentGemsPlugin;
import net.silentchaos512.gems.init.GemsEnchantments;
import net.silentchaos512.gems.init.GemsTags;

public class SuperchargingRecipeCategoryJei
implements IRecipeCategory<Recipe> {
    private static final int GUI_START_X = 0;
    private static final int GUI_START_Y = 117;
    private static final int GUI_WIDTH = 120;
    private static final int GUI_HEIGHT = 48;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public SuperchargingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SilentGemsPlugin.GUI_TEXTURE, 0, 117, 120, 48);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)SuperchargerBlock.INSTANCE.get()));
        this.arrow = guiHelper.drawableBuilder(SilentGemsPlugin.GUI_TEXTURE, 73, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = I18n.func_135052_a((String)"category.silentgems.supercharging", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return SilentGemsPlugin.SUPERCHARGING;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        Tag<Item> catalystTag = recipe.getCatalystTag();
        if (catalystTag == null) {
            return;
        }
        Ingredient partMaterial = recipe.part.getMaterials().getNormal();
        ingredients.setInputIngredients(Arrays.asList(partMaterial, Ingredient.func_199805_a(catalystTag)));
        ArrayList outputs = new ArrayList();
        Arrays.stream(partMaterial.func_193365_a()).forEach(stack -> {
            ItemStack copy = stack.func_77946_l();
            copy.func_77966_a((Enchantment)GemsEnchantments.supercharged, recipe.tier);
            outputs.add(copy);
        });
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(outputs));
    }

    public void setRecipe(IRecipeLayout recipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 19, 0);
        itemStacks.init(1, true, 19, 20);
        itemStacks.init(2, false, 78, 10);
        itemStacks.set(ingredients);
    }

    public void draw(Recipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(43, 10);
        Minecraft mc = Minecraft.func_71410_x();
        int chaos = SuperchargerTileEntity.getEmissionRate(3, recipe.tier);
        ChaosEmissionRate emissionRate = ChaosEmissionRate.fromAmount(chaos);
        String str = emissionRate.getEmissionText(chaos).func_150254_d();
        FontRenderer fontRenderer = mc.field_71466_p;
        mc.field_71466_p.getClass();
        fontRenderer.func_175063_a(str, 1.0f, (float)(48 - 9 + 1), -1);
    }

    static final class Recipe {
        final IGearPart part;
        final int tier;

        Recipe(IGearPart part, int tier) {
            this.part = part;
            this.tier = tier;
        }

        @Nullable
        Tag<Item> getCatalystTag() {
            if (this.tier == 1) {
                return GemsTags.Items.CHARGING_AGENT_TIER1;
            }
            if (this.tier == 2) {
                return GemsTags.Items.CHARGING_AGENT_TIER2;
            }
            if (this.tier == 3) {
                return GemsTags.Items.CHARGING_AGENT_TIER3;
            }
            return null;
        }
    }
}

