/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gems.api.chaos.ChaosEmissionRate;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterBlock;
import net.silentchaos512.gems.compat.jei.SilentGemsPlugin;
import net.silentchaos512.gems.crafting.tokenenchanter.TokenEnchanterRecipe;

public class TokenEnchanterRecipeCategoryJei
implements IRecipeCategory<TokenEnchanterRecipe> {
    private static final int GUI_START_X = 0;
    private static final int GUI_START_Y = 37;
    private static final int GUI_WIDTH = 133;
    private static final int GUI_HEIGHT = 50;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public TokenEnchanterRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SilentGemsPlugin.GUI_TEXTURE, 0, 37, 133, 50);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TokenEnchanterBlock.INSTANCE.get()));
        this.arrow = guiHelper.drawableBuilder(SilentGemsPlugin.GUI_TEXTURE, 73, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = I18n.func_135052_a((String)"category.silentgems.token_enchanting", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return SilentGemsPlugin.TOKEN_ENCHANTING;
    }

    public Class<? extends TokenEnchanterRecipe> getRecipeClass() {
        return TokenEnchanterRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(TokenEnchanterRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(recipe.getToken());
        inputs.addAll(recipe.getIngredientMap().keySet());
        ingredients.setInputIngredients(inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, TokenEnchanterRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 10);
        itemStacks.init(1, true, 26, 0);
        itemStacks.init(2, true, 44, 0);
        itemStacks.init(3, true, 62, 0);
        itemStacks.init(4, true, 26, 18);
        itemStacks.init(5, true, 44, 18);
        itemStacks.init(6, true, 62, 18);
        itemStacks.init(7, false, 111, 10);
        itemStacks.set(0, Arrays.asList(recipe.getToken().func_193365_a()));
        ArrayList inputs = new ArrayList();
        recipe.getIngredientMap().forEach((ingredient, count) -> {
            List<ItemStack> list = Arrays.asList(ingredient.func_193365_a());
            list.forEach(stack -> stack.func_190920_e(count.intValue()));
            inputs.add(list);
        });
        for (int i = 0; i < inputs.size(); ++i) {
            itemStacks.set(i + 1, (List)inputs.get(i));
        }
        itemStacks.set(7, recipe.getResult());
    }

    public void draw(TokenEnchanterRecipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(81, 11);
        Minecraft mc = Minecraft.func_71410_x();
        int chaos = recipe.getChaosGenerated();
        ChaosEmissionRate emissionRate = ChaosEmissionRate.fromAmount(chaos);
        String str = emissionRate.getEmissionText(chaos).func_150254_d();
        FontRenderer fontRenderer = mc.field_71466_p;
        mc.field_71466_p.getClass();
        fontRenderer.func_175063_a(str, 1.0f, (float)(50 - 9 - 1), -1);
    }
}

