/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.config;

import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLPaths;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.utils.config.BooleanValue;
import net.silentchaos512.utils.config.ConfigSpecWrapper;
import net.silentchaos512.utils.config.DoubleValue;
import net.silentchaos512.utils.config.IntValue;
import net.silentchaos512.utils.config.StringValue;

public final class GemsConfig {
    private static final ConfigSpecWrapper WRAPPER = ConfigSpecWrapper.create((Path)FMLPaths.CONFIGDIR.get().resolve("silentgems-common.toml"));
    public static final Common COMMON = new Common(WRAPPER);

    private GemsConfig() {
    }

    public static void init() {
        WRAPPER.validate();
        WRAPPER.validate();
    }

    public static class Common {
        public final StringValue baseBiomeSeedOverride;
        public final IntValue chaosCoalBurnTime;
        public final BooleanValue debugMasterSwitch;
        public final Supplier<Boolean> debugShowOverlay;
        public final Supplier<Boolean> debugExtraTooltipInfo;
        public final IntValue enderSlimeSpawnWeight;
        public final IntValue enderSlimeGroupSizeMin;
        public final IntValue enderSlimeGroupSizeMax;
        public final BooleanValue gearSoulsGetXpFromFakePlayers;
        public final IntValue glowroseMaxPlaceCount;
        public final IntValue glowroseNormalLight;
        public final IntValue glowrosePottedLight;
        public final IntValue glowroseSpawnTryCount;
        public final BooleanValue returnHomeAllowAnchors;
        public final BooleanValue returnHomeMatchGems;
        public final IntValue returnHomeMaxUses;
        public final IntValue returnHomeUseTime;
        public final DoubleValue soulGemDropRateAverage;
        public final DoubleValue soulGemDropRateBoss;
        public final DoubleValue soulGemDropRateDeviation;
        public final IntValue teleporterChaosCrossDimension;
        public final IntValue teleporterChaosPerBlock;
        public final IntValue teleporterFreeRange;
        public final IntValue teleporterSearchRadius;
        public final IntValue worldGenNetherGemsRegionSize;
        public final IntValue worldGenEndGemsRegionSize;
        public final IntValue worldGenOtherDimensionGemsRegionSize;

        Common(ConfigSpecWrapper wrapper) {
            this.baseBiomeSeedOverride = wrapper.builder("world.generation.baseBiomeSeedOverride").comment("Seed used when setting up ore generation. This affects what biomes gems can spawn in.", new String[]{"If left empty, your PC username is hashed to create the seed."}).defineString("");
            this.chaosCoalBurnTime = wrapper.builder("general.chaosCoalBurnTime").comment("The burn time (in ticks) of chaos coal (normal coal is 1600)").defineInRange(6400, 0, Integer.MAX_VALUE);
            this.debugMasterSwitch = wrapper.builder("debug.masterSwitch").comment("Must be true for any other debug settings to take effect").define(SilentGems.isDevBuild());
            this.debugShowOverlay = this.debugConfig(wrapper.builder("debug.showOverlay").comment("Display text on-screen with various information, such as player/world chaos").define(true));
            this.debugExtraTooltipInfo = this.debugConfig(wrapper.builder("debug.extraTooltipInfo").comment("Add additional tooltip information to some items").define(true));
            wrapper.comment("entity.enderSlime.spawn", "Ender slime spawn properties (REQUIRES RESTART)");
            this.enderSlimeSpawnWeight = wrapper.builder("entity.enderSlime.spawn.weight").comment("Spawn weight of ender slimes in The End. Set to zero to disable spawns.").defineInRange(3, 0, Integer.MAX_VALUE);
            this.enderSlimeGroupSizeMin = wrapper.builder("entity.enderSlime.spawn.minGroupSize").comment("Smallest possible group size").defineInRange(1, 1, Integer.MAX_VALUE);
            this.enderSlimeGroupSizeMax = wrapper.builder("entity.enderSlime.spawn.maxGroupSize").comment("Largest possible group size").defineInRange(2, 1, Integer.MAX_VALUE);
            this.gearSoulsGetXpFromFakePlayers = wrapper.builder("gearSoul.fakePlayersGetXp").comment("If true, gear souls can gain XP when being used by fake players (certain machines)").define(false);
            this.glowroseMaxPlaceCount = wrapper.builder("glowrose.world.maxPerPatch").comment("The most glowroses that can be in a single patch").defineInRange(16, 0, Integer.MAX_VALUE);
            this.glowroseNormalLight = wrapper.builder("glowrose.normalLight").comment("The light level of free-standing glowroses [0 ~ 15]", new String[]{"Requires a Minecraft restart"}).defineInRange(10, 0, 15);
            this.glowrosePottedLight = wrapper.builder("glowrose.pottedLight").comment("The light level of glowroses planted in vanilla flower pots [0 ~ 15]", new String[]{"Requires a Minecraft restart"}).defineInRange(15, 0, 15);
            this.glowroseSpawnTryCount = wrapper.builder("glowrose.world.placeTryCount").comment("The number of placement attempts when generating new chunks (higher numbers = bigger patches)", new String[]{"Note this is the number of 'attempts', not the actual number you will likely see in any given patch"}).defineInRange(40, 0, Integer.MAX_VALUE);
            this.returnHomeAllowAnchors = wrapper.builder("returnHomeCharm.allowAnchors").comment("Allow return home charms to be bound to teleporter anchors").define(true);
            this.returnHomeMatchGems = wrapper.builder("returnHomeCharm.sameGemOnly").comment("Only allow return home charms to be bound to teleporters made with the same gem").define(false);
            this.returnHomeMaxUses = wrapper.builder("returnHomeCharm.maxUses").comment("Durability of return home charms. 0 means unlimited. Charms with durability will still generate chaos when used.").defineInRange(0, 0, Integer.MAX_VALUE);
            this.returnHomeUseTime = wrapper.builder("returnHomeCharm.useTime").comment("The time (in ticks) the player must use a return home charm to activate it").defineInRange(16, 0, Integer.MAX_VALUE);
            wrapper.comment("soulGem.dropRate", "Drop rate of soul gems is randomly selected based on the world seed.", new String[]{"There is an average and a deviation, which makes a normal distribution.", "The numbers will tend to be close to average, but could occasionally be plus/minus a couple deviations."});
            this.soulGemDropRateAverage = wrapper.builder("soulGem.dropRate.average").comment("Average drop rate of soul gems (1 = 100%) [0 ~ 1]").defineInRange(0.025, 0.0, 1.0);
            this.soulGemDropRateBoss = wrapper.builder("soulGem.dropRate.boss").comment("The drop rate for boss creatures (overrides normal calculation) [0 ~ 1]").defineInRange(1.0, 0.0, 1.0);
            this.soulGemDropRateDeviation = wrapper.builder("soulGem.dropRate.deviation").comment("Standard deviation of drop rate (should be no more than a quarter of the average, preferably less) [0 ~ 1]").defineInRange(0.002, 0.0, 1.0);
            this.teleporterChaosCrossDimension = wrapper.builder("teleporter.chaos.crossDimension").comment("The chaos produced when traveling between dimensions using a teleport").defineInRange(50000, 0, Integer.MAX_VALUE);
            this.teleporterChaosPerBlock = wrapper.builder("teleporter.chaos.perBlock").comment("The chaos produced per block traveled (ignores Y-axis)", new String[]{" Does not apply when teleporting to another dimension"}).defineInRange(50, 0, Integer.MAX_VALUE);
            this.teleporterFreeRange = wrapper.builder("teleporter.chaos.freeRange").comment("When teleporting this distance or less, no chaos is produced (ignores Y-axis)").defineInRange(64, 0, Integer.MAX_VALUE);
            this.teleporterSearchRadius = wrapper.builder("teleporter.redstone.searchRadius").comment("All entities within this distance of a redstone teleporter will teleport when activated with redstone.", new String[]{"Default is 2 blocks, restricted to [1,16]"}).defineInRange(2, 1, 16);
            wrapper.comment("world.generation", "World generation settings (ores, etc.) Most of these REQUIRE A RESTART!");
            this.worldGenNetherGemsRegionSize = wrapper.builder("world.generation.nether.gems.regionSize").comment("The region size for gems in the Nether.", new String[]{"Each 'size x size' chunk area is a 'region', which contains a couple types of gems.", "Larger regions will make finding many types of gems more difficult."}).defineInRange(8, 1, Integer.MAX_VALUE);
            this.worldGenEndGemsRegionSize = wrapper.builder("world.generation.end.gems.regionSize").comment("The region size for gems in The End.", new String[]{"Each 'size x size' chunk area is a 'region', which contains a couple types of gems.", "Larger regions will make finding many types of gems more difficult."}).defineInRange(6, 1, Integer.MAX_VALUE);
            this.worldGenOtherDimensionGemsRegionSize = wrapper.builder("world.generation.other.gems.regionSize").comment("The region size for gems in non-vanilla dimensions.", new String[]{"Each 'size x size' chunk area is a 'region', which contains a couple types of gems.", "Larger regions will make finding many types of gems more difficult."}).defineInRange(4, 1, Integer.MAX_VALUE);
        }

        private Supplier<Boolean> debugConfig(BooleanValue config) {
            return () -> (Boolean)this.debugMasterSwitch.get() != false && (Boolean)config.get() != false;
        }
    }
}

