/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.altar;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class AltarRecipe {
    private static final String NBT_CATALYST_VALUE = "SilentGems.CatalystValue";
    private static final int CATALYST_VALUE = 100;
    private final ResourceLocation id;
    private int chaosGenerated;
    private int processTime;
    private int catalystConsumed;
    private ItemStack result;
    private Ingredient input;
    private Ingredient catalyst;

    public AltarRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(IInventory inv) {
        ItemStack inputStack = inv.func_70301_a(0);
        ItemStack catalystStack = inv.func_70301_a(1);
        return this.input.test(inputStack) && this.catalyst.test(catalystStack);
    }

    public ItemStack consumeCatalyst(ItemStack stack) {
        ItemStack result = stack.func_77946_l();
        int value = AltarRecipe.getCatalystAmount(result) - this.catalystConsumed;
        if (value > 0) {
            AltarRecipe.setCatalystAmount(result, value);
        } else {
            result.func_190918_g(1);
            if (!result.func_190926_b()) {
                AltarRecipe.setCatalystAmount(result, 100);
            }
        }
        return result;
    }

    public static int getCatalystAmount(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_196082_o().func_74764_b(NBT_CATALYST_VALUE)) {
            return 100;
        }
        return stack.func_196082_o().func_74762_e(NBT_CATALYST_VALUE);
    }

    private static void setCatalystAmount(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a(NBT_CATALYST_VALUE, amount);
    }

    public static AltarRecipe read(ResourceLocation id, JsonObject json) {
        AltarRecipe recipe = new AltarRecipe(id);
        recipe.chaosGenerated = JSONUtils.func_151208_a((JsonObject)json, (String)"chaosGenerated", (int)200);
        recipe.processTime = JSONUtils.func_151208_a((JsonObject)json, (String)"processTime", (int)100);
        recipe.catalystConsumed = JSONUtils.func_151208_a((JsonObject)json, (String)"catalystConsumed", (int)10);
        recipe.input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        recipe.catalyst = Ingredient.func_199802_a((JsonElement)json.get("catalyst"));
        JsonObject resultJson = json.get("result").getAsJsonObject();
        recipe.result = AltarRecipe.deserializeItem(resultJson);
        return recipe;
    }

    public static AltarRecipe read(ResourceLocation id, PacketBuffer buffer) {
        AltarRecipe recipe = new AltarRecipe(id);
        recipe.result = buffer.func_150791_c();
        recipe.input = Ingredient.func_199566_b((PacketBuffer)buffer);
        recipe.catalyst = Ingredient.func_199566_b((PacketBuffer)buffer);
        recipe.chaosGenerated = buffer.func_150792_a();
        recipe.processTime = buffer.func_150792_a();
        recipe.catalystConsumed = buffer.func_150792_a();
        return recipe;
    }

    public static void write(AltarRecipe recipe, PacketBuffer buffer) {
        buffer.func_150788_a(recipe.result);
        recipe.input.func_199564_a(buffer);
        recipe.catalyst.func_199564_a(buffer);
        buffer.func_150787_b(recipe.chaosGenerated);
        buffer.func_150787_b(recipe.processTime);
        buffer.func_150787_b(recipe.catalystConsumed);
    }

    private static ItemStack deserializeItem(JsonObject json) {
        return ShapedRecipe.func_199798_a((JsonObject)json);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getChaosGenerated() {
        return this.chaosGenerated;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getCatalystConsumed() {
        return this.catalystConsumed;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }
}

