/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.ingredient;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.lib.soul.SoulElement;
import net.silentchaos512.utils.EnumUtils;

public class SoulElementIngredient
extends Ingredient {
    private final SoulElement primary;
    private final SoulElement secondary;
    private ItemStack[] matchingStacks;

    public SoulElementIngredient(SoulElement primary, SoulElement secondary) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.primary = primary;
        this.secondary = secondary;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof SoulGemItem)) {
            return false;
        }
        return this.testSoul(SoulGemItem.getSoul(stack));
    }

    private boolean testSoul(@Nullable Soul soul) {
        return !(soul == null || this.primary != SoulElement.NONE && this.primary != soul.getPrimaryElement() || this.secondary != SoulElement.NONE && this.secondary != soul.getSecondaryElement());
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public ItemStack[] func_193365_a() {
        this.determineMatchingStacks();
        return this.matchingStacks;
    }

    private void determineMatchingStacks() {
        if (this.matchingStacks == null || this.matchingStacks.length == 0) {
            this.matchingStacks = (ItemStack[])Soul.getValues().stream().filter(this::testSoul).map(SoulGemItem::getStack).toArray(ItemStack[]::new);
        }
    }

    public boolean func_203189_d() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public static final class Serializer
    implements IIngredientSerializer<SoulElementIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGems.getId("soul_elements");

        public SoulElementIngredient parse(PacketBuffer buffer) {
            SoulElement primary = (SoulElement)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)SoulElement.NONE);
            SoulElement secondary = (SoulElement)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)SoulElement.NONE);
            return new SoulElementIngredient(primary, secondary);
        }

        public SoulElementIngredient parse(JsonObject json) {
            SoulElement primary = (SoulElement)EnumUtils.byName((String)JSONUtils.func_151219_a((JsonObject)json, (String)"primary", (String)"none"), (Enum)SoulElement.NONE);
            SoulElement secondary = (SoulElement)EnumUtils.byName((String)JSONUtils.func_151219_a((JsonObject)json, (String)"secondary", (String)"none"), (Enum)SoulElement.NONE);
            return new SoulElementIngredient(primary, secondary);
        }

        public void write(PacketBuffer buffer, SoulElementIngredient ingredient) {
            buffer.writeByte(ingredient.primary.ordinal());
            buffer.writeByte(ingredient.secondary.ordinal());
        }

        public static void register() {
            CraftingHelper.register((ResourceLocation)NAME, (IIngredientSerializer)INSTANCE);
        }
    }
}

