/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.EnchantmentTokenItem;

public class ApplyEnchantmentTokenRecipe
implements ICraftingRecipe {
    public static final ResourceLocation NAME = SilentGems.getId("apply_enchantment_token");
    public static final Serializer SERIALIZER = new Serializer();

    public boolean matches(CraftingInventory inv, World worldIn) {
        return !this.getCraftingResult(inv).func_190926_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack tool = ItemStack.field_190927_a;
        NonNullList tokens = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof EnchantmentTokenItem) {
                tokens.add(stack);
                continue;
            }
            if (!tool.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            tool = stack;
        }
        if (tool.func_190926_b() || tokens.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = tool.func_77946_l();
        for (ItemStack token : tokens) {
            if (EnchantmentTokenItem.applyTokenToTool(token, result)) continue;
            return ItemStack.field_190927_a;
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public String func_193358_e() {
        return "silentgems";
    }

    public boolean func_192399_d() {
        return true;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ApplyEnchantmentTokenRecipe> {
        private Serializer() {
        }

        public ApplyEnchantmentTokenRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new ApplyEnchantmentTokenRecipe();
        }

        public ApplyEnchantmentTokenRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new ApplyEnchantmentTokenRecipe();
        }

        public void write(PacketBuffer buffer, ApplyEnchantmentTokenRecipe recipe) {
        }
    }
}

