/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.item.GemItem;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.urn.IUrnUpgradeItem;
import net.silentchaos512.gems.lib.urn.UrnHelper;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.collection.StackList;

public class ModifySoulUrnRecipe
implements ICraftingRecipe {
    public static final ResourceLocation NAME = SilentGems.getId("modify_soul_urn");
    public static final Serializer SERIALIZER = new Serializer();

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack urn = list.uniqueMatch(ModifySoulUrnRecipe::isSoulUrn);
        Collection mods = list.allMatches(ModifySoulUrnRecipe::isModifierItem);
        Collection dyes = list.allMatches(s -> ModifySoulUrnRecipe.getDyeColor(s).isPresent());
        for (ItemStack mod : mods) {
            if (!(mod.func_77973_b() instanceof IUrnUpgradeItem)) continue;
            IUrnUpgradeItem upgradeItem = (IUrnUpgradeItem)mod.func_77973_b();
            NonNullList<UrnUpgrade> currentUpgrades = UrnUpgrade.ListHelper.load(urn);
            if (!UrnUpgrade.ListHelper.contains(currentUpgrades, upgradeItem.getSerializer())) continue;
            return false;
        }
        return !urn.func_190926_b() && (list.size() == 1 || !mods.isEmpty() || !dyes.isEmpty());
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack urn = list.uniqueMatch(ModifySoulUrnRecipe::isSoulUrn).func_77946_l();
        Collection mods = list.allMatches(ModifySoulUrnRecipe::isModifierItem);
        Collection dyes = list.allMatches(s -> ModifySoulUrnRecipe.getDyeColor(s).isPresent());
        if (mods.isEmpty() && dyes.isEmpty()) {
            UrnHelper.toggleHasLid(urn);
        } else {
            mods.forEach(mod -> ModifySoulUrnRecipe.applyModifierItem(urn, mod));
            ModifySoulUrnRecipe.applyDyes(urn, dyes);
        }
        return urn;
    }

    private static boolean isSoulUrn(ItemStack stack) {
        return stack.func_77973_b() == GemsBlocks.soulUrn.func_199767_j();
    }

    private static boolean isModifierItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof GemItem || item instanceof IUrnUpgradeItem;
    }

    private static void applyModifierItem(ItemStack urn, ItemStack mod) {
        SilentGems.LOGGER.debug("ModifySoulUrnRecipe#applyModifierItem: {}, {}", (Object)urn, (Object)mod);
        if (mod.func_77973_b() instanceof GemItem) {
            Gems gem = Gems.from(mod);
            assert (gem != null);
            UrnHelper.setGem(urn, gem);
        } else if (mod.func_77973_b() instanceof IUrnUpgradeItem) {
            IUrnUpgradeItem upgradeItem = (IUrnUpgradeItem)mod.func_77973_b();
            CompoundNBT urnSubcompound = urn.func_190925_c("BlockEntityTag");
            NonNullList<UrnUpgrade> list = UrnUpgrade.ListHelper.load(urnSubcompound);
            list.add(upgradeItem.getSerializer().deserialize(new CompoundNBT()));
            UrnUpgrade.ListHelper.save(list, urnSubcompound);
        }
    }

    private static void applyDyes(ItemStack urn, Collection<ItemStack> dyes) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int clayColor = UrnHelper.getClayColor(urn);
        if (clayColor != 9985861) {
            float r = (float)(clayColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(clayColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(clayColor & 0xFF) / 255.0f;
            maxColorSum = (int)((float)maxColorSum + Math.max(r, Math.max(g, b)) * 255.0f);
            componentSums[0] = (int)((float)componentSums[0] + r * 255.0f);
            componentSums[1] = (int)((float)componentSums[1] + g * 255.0f);
            componentSums[2] = (int)((float)componentSums[2] + b * 255.0f);
            ++colorCount;
        }
        for (ItemStack dye : dyes) {
            float[] componentValues = ModifySoulUrnRecipe.getDyeColor(dye).orElse(DyeColor.WHITE).func_193349_f();
            int r = (int)(componentValues[0] * 255.0f);
            int g = (int)(componentValues[1] * 255.0f);
            int b = (int)(componentValues[2] * 255.0f);
            maxColorSum += Math.max(r, Math.max(g, b));
            componentSums[0] = componentSums[0] + r;
            componentSums[1] = componentSums[1] + g;
            componentSums[2] = componentSums[2] + b;
            ++colorCount;
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            UrnHelper.setClayColor(urn, finalColor);
        }
    }

    private static Optional<DyeColor> getDyeColor(ItemStack dye) {
        return Optional.ofNullable(DyeColor.getColor((ItemStack)dye));
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)GemsBlocks.soulUrn);
    }

    public boolean func_192399_d() {
        return true;
    }

    public String func_193358_e() {
        return "silentgems";
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ModifySoulUrnRecipe> {
        private Serializer() {
        }

        public ModifySoulUrnRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new ModifySoulUrnRecipe();
        }

        public ModifySoulUrnRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new ModifySoulUrnRecipe();
        }

        public void write(PacketBuffer buffer, ModifySoulUrnRecipe recipe) {
        }
    }
}

