/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.FireAspectEnchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.silentchaos512.gems.enchantment.EnchantmentLightningAspect;
import net.silentchaos512.gems.init.GemsEffects;

public class EnchantmentIceAspect
extends Enchantment {
    public static final int EFFECT_DURATION = 80;
    public static boolean ENABLED = true;

    public EnchantmentIceAspect() {
        super(Enchantment.Rarity.RARE, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public boolean func_77326_a(Enchantment ench) {
        return !(ench instanceof FireAspectEnchantment) && !(ench instanceof EnchantmentLightningAspect) && super.func_77326_a(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (!ENABLED) {
            return false;
        }
        return stack.func_77973_b() instanceof SwordItem;
    }

    public int func_77321_a(int level) {
        return 10 + 20 * (level - 1);
    }

    public int func_77325_b() {
        return 2;
    }

    public static void applyTo(LivingEntity entityLiving, int enchLevel) {
        int duration = EnchantmentIceAspect.getEffectDuration(entityLiving, enchLevel);
        int amplifier = enchLevel - 1;
        entityLiving.func_195064_c(new EffectInstance((Effect)GemsEffects.freezing, duration, amplifier, true, false));
    }

    private static int getEffectDuration(LivingEntity entityLiving, int enchLevel) {
        int ret = 80 + (enchLevel - 1) * 80 / 2;
        if (entityLiving instanceof PlayerEntity) {
            ret /= 2;
        }
        return ret;
    }
}

