/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.PacketDistributor;
import net.silentchaos512.gems.entity.projectile.AbstractWispShotEntity;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.gems.network.Network;
import net.silentchaos512.gems.network.SpawnEntityPacket;

public abstract class AbstractWispEntity
extends MonsterEntity {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;

    public AbstractWispEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public abstract WispTypes getWispType();

    protected abstract AbstractWispShotEntity getProjectile(AbstractWispEntity var1, double var2, double var4, double var6);

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new WispAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return super.func_184601_bQ(damageSourceIn);
    }

    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        LivingEntity target;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((target = this.func_70638_az()) != null && target.field_70163_u + (double)target.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset && this.func_213336_c(target)) {
            Vec3d vec3d = this.func_213322_ci();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vec3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected ResourceLocation func_184647_J() {
        return super.func_184647_J();
    }

    static class WispAttackGoal
    extends Goal {
        private final AbstractWispEntity wisp;
        private int attackStep;
        private int attackTime;
        private int field_223527_d;

        public WispAttackGoal(AbstractWispEntity wispIn) {
            this.wisp = wispIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.wisp.func_70638_az();
            return target != null && target.func_70089_S() && this.wisp.func_213336_c(target);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.field_223527_d = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity target = this.wisp.func_70638_az();
            if (target != null) {
                boolean canSeeTarget = this.wisp.func_70635_at().func_75522_a((Entity)target);
                this.field_223527_d = canSeeTarget ? 0 : ++this.field_223527_d;
                double distanceSq = this.wisp.func_70068_e((Entity)target);
                if (distanceSq < 4.0) {
                    if (!canSeeTarget) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.wisp.func_70652_k((Entity)target);
                    }
                    this.wisp.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
                } else if (distanceSq < this.getFollowDistance() * this.getFollowDistance() && canSeeTarget) {
                    double dx = target.field_70165_t - this.wisp.field_70165_t;
                    double dy = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f) - (this.wisp.field_70163_u + (double)(this.wisp.func_213302_cg() / 2.0f));
                    double dz = target.field_70161_v - this.wisp.field_70161_v;
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)distanceSq)) * 0.5f;
                            this.wisp.field_70170_p.func_217378_a(null, 1018, new BlockPos((Entity)this.wisp), 0);
                            for (int i = 0; i < 1; ++i) {
                                AbstractWispShotEntity shot = this.wisp.getProjectile(this.wisp, dx + this.wisp.func_70681_au().nextGaussian() * (double)f, dy, dz + this.wisp.func_70681_au().nextGaussian() * (double)f);
                                shot.setColor(this.wisp.getWispType().getColor().getColor());
                                shot.field_70163_u = this.wisp.field_70163_u + (double)(this.wisp.func_213302_cg() / 2.0f) + 0.5;
                                this.wisp.field_70170_p.func_217376_c((Entity)shot);
                                Supplier p = PacketDistributor.TargetPoint.p((double)this.wisp.field_70165_t, (double)this.wisp.field_70163_u, (double)this.wisp.field_70161_v, (double)4096.0, (DimensionType)this.wisp.field_71093_bK);
                                Network.channel.send(PacketDistributor.NEAR.with(p), (Object)new SpawnEntityPacket((Entity)shot));
                            }
                        }
                    }
                    this.wisp.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
                } else if (this.field_223527_d < 5) {
                    this.wisp.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.wisp.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }
    }
}

