/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gems.SilentGems;

public class EnderSlimeEntity
extends SlimeEntity {
    private static final ResourceLocation LOOT_TABLE = SilentGems.getId("ender_slime");

    public EnderSlimeEntity(EntityType<? extends EnderSlimeEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public static boolean canSpawnAt(EntityType<EnderSlimeEntity> entityType, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_217346_i((Entity)this) && !worldIn.func_72953_d(this.func_174813_aQ());
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        super.func_70799_a(size, resetHealth);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)(size * 3));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Nonnull
    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197616_i;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected int func_70806_k() {
        return super.func_70806_k() * 4;
    }

    protected void func_70808_l() {
        this.field_70813_a *= 0.9f;
    }

    protected void func_70664_aZ() {
        Vec3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, 0.42f + (float)this.func_70809_q() * 0.1f, vec3d.field_72449_c);
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    protected void func_180466_bG(Tag<Fluid> p_180466_1_) {
        if (p_180466_1_ == FluidTags.field_206960_b) {
            Vec3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a, 0.22f + (float)this.func_70809_q() * 0.05f, vec3d.field_72449_c);
            this.field_70160_al = true;
        } else {
            super.func_180466_bG(p_180466_1_);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected boolean func_70800_m() {
        return this.func_70613_aW();
    }

    protected int func_70805_n() {
        return super.func_70805_n() + 2;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_189101_db() ? SoundEvents.field_187892_fv : SoundEvents.field_187760_dh;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_189101_db() ? SoundEvents.field_187890_fu : SoundEvents.field_187758_dg;
    }

    @Nonnull
    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187894_fw : SoundEvents.field_187764_dj;
    }

    @Nonnull
    protected SoundEvent func_184710_cZ() {
        return SoundEvents.field_187762_di;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockPos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockPos).func_185904_a().func_76230_c()) {
            blockPos.func_189536_c(Direction.DOWN);
        }
        if (!this.field_70170_p.func_180495_p((BlockPos)blockPos).func_185904_a().func_76230_c()) {
            return false;
        }
        EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (flag) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected void func_70619_bc() {
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        super.func_70619_bc();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }
}

