/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class AbstractChaosMagicEntity
extends DamagingProjectileEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(AbstractChaosMagicEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int ticksAlive;
    private int ticksInAir;

    public AbstractChaosMagicEntity(EntityType<? extends AbstractChaosMagicEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public AbstractChaosMagicEntity(EntityType<? extends AbstractChaosMagicEntity> typeIn, double posXIn, double posYIn, double posZIn, double accelX, double accelY, double accelZ, World worldIn) {
        super(typeIn, posXIn, posYIn, posZIn, accelX, accelY, accelZ, worldIn);
    }

    public AbstractChaosMagicEntity(EntityType<? extends AbstractChaosMagicEntity> typeIn, LivingEntity shooterIn, double accelX, double accelY, double accelZ, World worldIn) {
        super(typeIn, shooterIn, accelX, accelY, accelZ, worldIn);
    }

    protected abstract void onEntityImpact(Entity var1);

    protected abstract void onBlockImpact(BlockPos var1, Direction var2);

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0xFFFFFF);
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                this.onEntityImpact(entity);
            } else if (this.field_70235_a == null || !(this.field_70235_a instanceof MobEntity) || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.field_70235_a)) {
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
                this.onBlockImpact(blockraytraceresult.func_216350_a(), blockraytraceresult.func_216354_b());
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197614_g;
    }

    protected boolean func_184564_k() {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.getColor());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setColor(additionalData.func_150792_a());
    }
}

