/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity.projectile;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.entity.projectile.AbstractWispShotEntity;
import net.silentchaos512.gems.init.GemsEffects;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.gems.util.ModDamageSource;
import net.silentchaos512.lib.util.TimeUtils;

public class IceWispShotEntity
extends AbstractWispShotEntity {
    private static final int FREEZE_DURATION = TimeUtils.ticksFromSeconds((float)5.0f);

    public IceWispShotEntity(World worldIn) {
        this(WispTypes.ICE.getShotType(), worldIn);
    }

    public IceWispShotEntity(EntityType<? extends AbstractWispShotEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public IceWispShotEntity(EntityType<? extends AbstractWispShotEntity> typeIn, double posXIn, double posYIn, double posZIn, double accelX, double accelY, double accelZ, World worldIn) {
        super(typeIn, posXIn, posYIn, posZIn, accelX, accelY, accelZ, worldIn);
    }

    public IceWispShotEntity(EntityType<? extends AbstractWispShotEntity> typeIn, LivingEntity shooterIn, double accelX, double accelY, double accelZ, World worldIn) {
        super(typeIn, shooterIn, accelX, accelY, accelZ, worldIn);
    }

    @Override
    protected void onEntityImpact(Entity entityIn) {
        LivingEntity livingEntity;
        if (entityIn instanceof LivingEntity && this.attackEntity(livingEntity = (LivingEntity)entityIn)) {
            EffectInstance effect = new EffectInstance((Effect)GemsEffects.freezing, FREEZE_DURATION, 0, false, false);
            livingEntity.func_195064_c(effect);
        }
    }

    private boolean attackEntity(LivingEntity entity) {
        if (entity.func_70660_b(GemsEffects.insulated) != null) {
            return false;
        }
        return entity.func_70097_a(ModDamageSource.causeWispShotDamage(this, (Entity)this.field_70235_a), 4.0f);
    }

    @Override
    protected void onBlockImpact(BlockPos pos, Direction side) {
        BlockPos blockPos = pos.func_177972_a(side);
        if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j) {
            this.field_70170_p.func_175656_a(blockPos, Blocks.field_150432_aD.func_176223_P());
        }
    }
}

