/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.init.GemsTraits;
import net.silentchaos512.utils.MathUtils;

public final class TraitEvents {
    public static final TraitEvents INSTANCE = new TraitEvents();

    private TraitEvents() {
    }

    @SubscribeEvent
    public void criticalHit(CriticalHitEvent event) {
        int critical;
        PlayerEntity player = event.getPlayer();
        ItemStack weapon = player.func_184614_ca();
        if (GearHelper.isGear((ItemStack)weapon) && (critical = TraitHelper.getTraitLevel((ItemStack)weapon, (ResourceLocation)GemsTraits.CRITICAL)) > 0 && MathUtils.tryPercentage((double)(0.1 * (double)critical))) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerAttack(AttackEntityEvent event) {
        int chaotic;
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184614_ca();
        if (!tool.func_190926_b() && tool.func_77973_b() instanceof ICoreTool && (chaotic = TraitHelper.getTraitLevel((ItemStack)tool, (ResourceLocation)GemsTraits.CHAOTIC)) > 0) {
            Chaos.generate(player, 100 * chaotic, true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        if (!(attacker instanceof ServerPlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)attacker;
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICoreTool) {
            int sol;
            int luna = TraitHelper.getTraitLevel((ItemStack)stack, (ResourceLocation)GemsTraits.LUNA);
            if (luna > 0 && !player.field_70170_p.func_72935_r() && MathUtils.tryPercentage((double)0.25)) {
                event.setAmount(event.getAmount() + (float)(4 * luna));
                TraitEvents.knockback((LivingEntity)player, event.getEntityLiving(), 0.3f * (float)luna);
            }
            if ((sol = TraitHelper.getTraitLevel((ItemStack)stack, (ResourceLocation)GemsTraits.SOL)) > 0 && player.field_70170_p.func_72935_r() && MathUtils.tryPercentage((double)0.25)) {
                event.setAmount(event.getAmount() + (float)(4 * sol));
                TraitEvents.knockback((LivingEntity)player, event.getEntityLiving(), 0.3f * (float)sol);
            }
        }
    }

    private static void knockback(LivingEntity attacker, LivingEntity target, float strength) {
        double x = attacker.field_70165_t - target.field_70165_t;
        double z = attacker.field_70161_v - target.field_70161_v;
        while (x * x + z * z < 1.0E-4) {
            x = (Math.random() - Math.random()) * 0.01;
            z = (Math.random() - Math.random()) * 0.01;
        }
        target.func_70653_a((Entity)attacker, strength, x, z);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        int chaotic;
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184614_ca();
        if (!tool.func_190926_b() && tool.func_77973_b() instanceof ICoreTool && (chaotic = TraitHelper.getTraitLevel((ItemStack)tool, (ResourceLocation)GemsTraits.CHAOTIC)) > 0) {
            Chaos.generate(player, 100 * chaotic, true);
        }
    }

    @SubscribeEvent
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        int entropy;
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184614_ca();
        if (!tool.func_190926_b() && GearHelper.isGear((ItemStack)tool) && (entropy = TraitHelper.getTraitLevel((ItemStack)tool, (ResourceLocation)GemsTraits.ENTROPY)) > 0) {
            float chaosRatio = (Chaos.getChaos((ICapabilityProvider)player) + Chaos.getChaos((ICapabilityProvider)player.field_70170_p)) / 5000000;
            float ratioClamped = MathHelper.func_76131_a((float)chaosRatio, (float)0.0f, (float)1.0f);
            event.setNewSpeed(event.getNewSpeed() + (float)(3 * entropy) * ratioClamped);
        }
    }
}

