/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.FluffyBlock;
import net.silentchaos512.gems.block.FluffyPuffPlant;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.block.flowerpot.LuminousFlowerPotBlock;
import net.silentchaos512.gems.block.flowerpot.PhantomLightBlock;
import net.silentchaos512.gems.block.pedestal.PedestalBlock;
import net.silentchaos512.gems.block.supercharger.SuperchargerBlock;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.TeleporterAnchorBlock;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterBlock;
import net.silentchaos512.gems.block.urn.SoulUrnBlock;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.item.GemBlockItem;
import net.silentchaos512.gems.lib.Gems;

public final class GemsBlocks {
    public static final List<PedestalBlock> pedestals = new ArrayList<PedestalBlock>();
    public static final List<GemTeleporterBlock> teleporters = new ArrayList<GemTeleporterBlock>();
    public static SoulUrnBlock soulUrn;

    private GemsBlocks() {
    }

    public static void registerAll(RegistryEvent.Register<Block> event) {
        GemsBlocks.registerGemBlocks(Gems::getOre, gem -> gem.func_176610_l() + "_ore");
        GemsBlocks.registerGemBlocks(Gems::getBlock, gem -> gem.func_176610_l() + "_block");
        GemsBlocks.registerGemBlocks(Gems::getBricks, gem -> gem.func_176610_l() + "_bricks");
        GemsBlocks.registerGemBlocks(Gems::getGlass, gem -> gem.func_176610_l() + "_glass");
        for (GemLampBlock.State state : GemLampBlock.State.values()) {
            Function<Gems, Block> blockFactory = gem -> gem.getLamp(state);
            Function<Gems, String> nameFactory = gem -> GemLampBlock.nameFor(gem, state);
            if (state.hasItem()) {
                GemsBlocks.registerGemBlocks(blockFactory, nameFactory);
                continue;
            }
            GemsBlocks.registerGemBlocksNoItem(blockFactory, nameFactory);
        }
        GemsBlocks.registerGemBlocks(Gems::getGlowrose, gem -> gem.func_176610_l() + "_glowrose");
        GemsBlocks.registerGemBlocksNoItem(Gems::getPottedGlowrose, gem -> "potted_" + gem.func_176610_l() + "_glowrose");
        GemsBlocks.registerGemBlocks(Gems::getTeleporter, gem -> gem.func_176610_l() + "_teleporter", teleporters::add);
        GemsBlocks.registerGemBlocks(Gems::getRedstoneTeleporter, gem -> gem.func_176610_l() + "_redstone_teleporter", teleporters::add);
        teleporters.add((GemTeleporterBlock)GemsBlocks.register("teleporter_anchor", (Block)TeleporterAnchorBlock.INSTANCE.get()));
        GemsBlocks.register("multi_ore_classic", Gems.Set.CLASSIC.getMultiOre());
        GemsBlocks.register("multi_ore_dark", Gems.Set.DARK.getMultiOre());
        GemsBlocks.register("multi_ore_light", Gems.Set.LIGHT.getMultiOre());
        for (Enum enum_ : MiscBlocks.values()) {
            GemsBlocks.register(((MiscBlocks)enum_).func_176610_l(), ((MiscBlocks)enum_).getBlock(), ((MiscBlocks)enum_).getBlockItem());
        }
        for (Enum enum_ : MiscOres.values()) {
            GemsBlocks.register(((MiscOres)enum_).func_176610_l(), ((MiscOres)enum_).getBlock());
        }
        for (Enum enum_ : HardenedRock.values()) {
            GemsBlocks.register(((HardenedRock)enum_).func_176610_l(), ((HardenedRock)enum_).asBlock());
        }
        for (Enum enum_ : CorruptedBlocks.values()) {
            GemsBlocks.register(((CorruptedBlocks)enum_).getName(), ((CorruptedBlocks)enum_).asBlock());
        }
        for (Enum enum_ : DyeColor.values()) {
            GemsBlocks.register(enum_.func_176610_l() + "_fluffy_block", FluffyBlock.get((DyeColor)enum_));
        }
        soulUrn = (SoulUrnBlock)GemsBlocks.register("soul_urn", (Block)SoulUrnBlock.INSTANCE.get(), new SoulUrnBlock.SoulUrnBlockItem((SoulUrnBlock)((Object)SoulUrnBlock.INSTANCE.get())));
        GemsBlocks.register("supercharger", (Block)SuperchargerBlock.INSTANCE.get());
        GemsBlocks.register("token_enchanter", (Block)TokenEnchanterBlock.INSTANCE.get());
        GemsBlocks.registerPedestal("stone_pedestal", new PedestalBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        GemsBlocks.registerPedestal("granite_pedestal", new PedestalBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        GemsBlocks.registerPedestal("diorite_pedestal", new PedestalBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        GemsBlocks.registerPedestal("andesite_pedestal", new PedestalBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        GemsBlocks.registerPedestal("obsidian_pedestal", new PedestalBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(30.0f, 1200.0f).func_200947_a(SoundType.field_185851_d)));
        GemsBlocks.register("luminous_flower_pot", (Block)LuminousFlowerPotBlock.INSTANCE.get());
        GemsBlocks.register("phantom_light", (Block)PhantomLightBlock.INSTANCE.get(), null);
        GemsBlocks.register("fluffy_puff_plant", (Block)FluffyPuffPlant.NORMAL.get(), null);
        GemsBlocks.register("wild_fluffy_puff_plant", (Block)FluffyPuffPlant.WILD.get(), null);
    }

    private static void registerPedestal(String name, PedestalBlock block) {
        GemsBlocks.register(name, block);
        pedestals.add(block);
    }

    private static <T extends Block> T register(String name, T block) {
        GemBlockItem item = new GemBlockItem(block, new Item.Properties().func_200916_a(GemsItemGroups.BLOCKS));
        return GemsBlocks.register(name, block, item);
    }

    private static <T extends Block> T register(String name, T block, @Nullable BlockItem item) {
        ResourceLocation id = SilentGems.getId(name);
        block.setRegistryName(id);
        ForgeRegistries.BLOCKS.register(block);
        if (item != null) {
            item.setRegistryName(id);
            GemsItems.BLOCKS_TO_REGISTER.add(item);
        }
        return block;
    }

    private static <T extends Block> void registerGemBlocks(Function<Gems, T> factory, Function<Gems, String> name) {
        GemsBlocks.registerGemBlocks(factory, name, t -> {});
    }

    private static <T extends Block> void registerGemBlocks(Function<Gems, T> factory, Function<Gems, String> name, Consumer<T> extraAction) {
        for (Gems gem : Gems.values()) {
            Block block = (Block)factory.apply(gem);
            GemsBlocks.register(name.apply(gem), block);
            extraAction.accept(block);
        }
    }

    private static <T extends Block> void registerGemBlocksNoItem(Function<Gems, T> factory, Function<Gems, String> name) {
        for (Gems gem : Gems.values()) {
            GemsBlocks.register(name.apply(gem), (Block)factory.apply(gem), null);
        }
    }
}

