/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.Locale;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.altar.AltarContainer;
import net.silentchaos512.gems.block.altar.AltarScreen;
import net.silentchaos512.gems.block.supercharger.SuperchargerContainer;
import net.silentchaos512.gems.block.supercharger.SuperchargerScreen;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterContainer;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterScreen;
import net.silentchaos512.gems.block.urn.SoulUrnContainer;
import net.silentchaos512.gems.block.urn.SoulUrnScreen;
import net.silentchaos512.gems.item.container.GemBagContainer;
import net.silentchaos512.gems.item.container.GemContainerScreen;
import net.silentchaos512.gems.item.container.GlowroseBasketContainer;
import net.silentchaos512.utils.Lazy;

public enum GemsContainers {
    GEM_BAG(GemBagContainer::new),
    GLOWROSE_BASKET(GlowroseBasketContainer::new),
    SOUL_URN(SoulUrnContainer::new),
    SUPERCHARGER(SuperchargerContainer::new),
    TOKEN_ENCHANTER(TokenEnchanterContainer::new),
    TRANSMUTATION_ALTAR(AltarContainer::new);

    private final Lazy<ContainerType<?>> type = Lazy.of(() -> new ContainerType(factory));

    private GemsContainers(ContainerType.IFactory<?> factory) {
    }

    public ContainerType<?> type() {
        return (ContainerType)this.type.get();
    }

    public static void registerAll(RegistryEvent.Register<ContainerType<?>> event) {
        for (GemsContainers container : GemsContainers.values()) {
            GemsContainers.register(container.name().toLowerCase(Locale.ROOT), container.type());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreens(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(GEM_BAG.type(), GemContainerScreen::new);
        ScreenManager.func_216911_a(GLOWROSE_BASKET.type(), GemContainerScreen::new);
        ScreenManager.func_216911_a(SOUL_URN.type(), SoulUrnScreen::new);
        ScreenManager.func_216911_a(SUPERCHARGER.type(), SuperchargerScreen::new);
        ScreenManager.func_216911_a(TOKEN_ENCHANTER.type(), TokenEnchanterScreen::new);
        ScreenManager.func_216911_a(TRANSMUTATION_ALTAR.type(), AltarScreen::new);
    }

    private static void register(String name, ContainerType<?> type) {
        ResourceLocation id = SilentGems.getId(name);
        type.setRegistryName(id);
        ForgeRegistries.CONTAINERS.register(type);
    }
}

