/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.render.entity.EnderSlimeRenderer;
import net.silentchaos512.gems.client.render.entity.WispRenderer;
import net.silentchaos512.gems.client.render.entity.WispShotRenderer;
import net.silentchaos512.gems.entity.ChaosWispEntity;
import net.silentchaos512.gems.entity.EnderSlimeEntity;
import net.silentchaos512.gems.entity.FireWispEntity;
import net.silentchaos512.gems.entity.IceWispEntity;
import net.silentchaos512.gems.entity.LightningWispEntity;
import net.silentchaos512.gems.entity.WaterWispEntity;
import net.silentchaos512.gems.entity.projectile.ChaosWispShotEntity;
import net.silentchaos512.gems.entity.projectile.FireWispShotEntity;
import net.silentchaos512.gems.entity.projectile.IceWispShotEntity;
import net.silentchaos512.gems.entity.projectile.LightningWispShotEntity;
import net.silentchaos512.gems.entity.projectile.WaterWispShotEntity;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.utils.Lazy;

public enum GemsEntities {
    ENDER_SLIME(() -> EntityType.Builder.func_220322_a(EnderSlimeEntity::new, (EntityClassification)EntityClassification.MONSTER), 13107, 0xAA00AA);

    private final Lazy<EntityType<?>> entityType = Lazy.of(() -> {
        ResourceLocation id = SilentGems.getId(this.getName());
        return ((EntityType.Builder)factory.get()).func_206830_a(id.toString());
    });
    private final Lazy<SpawnEggItem> spawnEgg = Lazy.of(() -> {
        Item.Properties props = new Item.Properties().func_200916_a(ItemGroup.field_78026_f);
        return new SpawnEggItem(this.type(), eggPrimaryColor, eggSecondaryColor, props);
    });

    private GemsEntities(Supplier<EntityType.Builder<?>> factory, int eggPrimaryColor, int eggSecondaryColor) {
    }

    public EntityType<?> type() {
        return (EntityType)this.entityType.get();
    }

    public SpawnEggItem getSpawnEgg() {
        return (SpawnEggItem)this.spawnEgg.get();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static void registerAll(RegistryEvent.Register<EntityType<?>> event) {
        Arrays.stream(GemsEntities.values()).forEach(e -> GemsEntities.registerType(e.getName(), e.type()));
        for (WispTypes wispType : WispTypes.values()) {
            GemsEntities.registerType(wispType.getName(), wispType.getEntityType());
            GemsEntities.registerType(wispType.getName() + "_shot", wispType.getShotType());
        }
    }

    private static void registerType(String name, EntityType<?> type) {
        ResourceLocation id = SilentGems.getId(name);
        type.setRegistryName(id);
        ForgeRegistries.ENTITIES.register(type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EnderSlimeEntity.class, EnderSlimeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ChaosWispEntity.class, WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(FireWispEntity.class, WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(IceWispEntity.class, WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(LightningWispEntity.class, WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WaterWispEntity.class, WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ChaosWispShotEntity.class, WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(FireWispShotEntity.class, WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(IceWispShotEntity.class, WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(LightningWispShotEntity.class, WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WaterWispShotEntity.class, WispShotRenderer::new);
    }
}

