/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.FluffyPuffPlant;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.init.GemsEntities;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.item.ChaosMeterItem;
import net.silentchaos512.gems.item.ChaosOrbItem;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.item.GlowroseFertilizerItem;
import net.silentchaos512.gems.item.ModFoods;
import net.silentchaos512.gems.item.PatchBlockChangerItem;
import net.silentchaos512.gems.item.PetSummonerItem;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.item.SoulUrnUpgrades;
import net.silentchaos512.gems.item.TeleporterLinkerItem;
import net.silentchaos512.gems.item.container.GemBagItem;
import net.silentchaos512.gems.item.container.GlowroseBasketItem;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.WispTypes;

public final class GemsItems {
    public static BlockNamedItem fluffyPuffSeeds;
    public static PetSummonerItem summonKitty;
    public static PetSummonerItem summonPuppy;
    static final Collection<BlockItem> BLOCKS_TO_REGISTER;

    private GemsItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        BLOCKS_TO_REGISTER.forEach(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).register(arg_0));
        GemsItems.registerGemItems(Gems::getItem, Gems::func_176610_l);
        GemsItems.registerGemItems(Gems::getShard, gem -> gem.func_176610_l() + "_shard");
        GemsItems.register("soul_gem", (Item)SoulGemItem.INSTANCE.get());
        if (SGearProxy.isLoaded()) {
            GemsItems.register("gear_soul", (Item)GearSoulItem.INSTANCE.get());
        }
        for (CraftingItems craftingItems : CraftingItems.values()) {
            GemsItems.register(craftingItems.func_176610_l(), craftingItems.func_199767_j());
        }
        GemsItems.register("enchantment_token", (Item)EnchantmentTokenItem.INSTANCE.get());
        GemsItems.registerGemItems(Gems::getReturnHomeCharm, gem -> gem.func_176610_l() + "_return_home_charm");
        GemsItems.register("teleporter_linker", (Item)TeleporterLinkerItem.INSTANCE.get());
        GemsItems.registerGemItems(Gems::getChaosGem, gem -> "chaos_" + gem.func_176610_l());
        GemsItems.register("chaos_rune", (Item)ChaosRuneItem.INSTANCE.get());
        GemsItems.register("chaos_potato", new ChaosOrbItem(0, 5000, 0.5f));
        GemsItems.register("fragile_chaos_orb", new ChaosOrbItem(2, 100000, 0.2f));
        GemsItems.register("refined_chaos_orb", new ChaosOrbItem(4, 1000000, 0.1f));
        GemsItems.register("perfect_chaos_orb", new ChaosOrbItem(4, 10000000, 0.05f));
        fluffyPuffSeeds = GemsItems.register("fluffy_puff_seeds", new BlockNamedItem((Block)FluffyPuffPlant.NORMAL.get(), new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS)));
        GemsItems.register("glowrose_fertilizer", (Item)GlowroseFertilizerItem.INSTANCE.get());
        for (Enum enum_ : SoulUrnUpgrades.values()) {
            GemsItems.register(((SoulUrnUpgrades)enum_).getName(), ((SoulUrnUpgrades)enum_).asItem());
        }
        for (Enum enum_ : CorruptedBlocks.values()) {
            GemsItems.register(((CorruptedBlocks)enum_).getName() + "_pile", ((CorruptedBlocks)enum_).getPile());
        }
        GemsItems.register("corrupting_powder", (Item)PatchBlockChangerItem.CORRUPTING_POWDER.get());
        GemsItems.register("purifying_powder", (Item)PatchBlockChangerItem.PURIFYING_POWDER.get());
        GemsItems.register("chaos_meter", (Item)ChaosMeterItem.INSTANCE.get());
        GemsItems.register("gem_bag", new GemBagItem());
        GemsItems.register("glowrose_basket", new GlowroseBasketItem());
        for (Enum enum_ : ModFoods.values()) {
            GemsItems.register(((ModFoods)enum_).func_176610_l(), ((ModFoods)enum_).func_199767_j());
        }
        summonKitty = GemsItems.register("summon_kitty", new PetSummonerItem(PetSummonerItem::getCat));
        summonPuppy = GemsItems.register("summon_puppy", new PetSummonerItem(PetSummonerItem::getDog));
        Arrays.stream(GemsEntities.values()).forEach(entity -> GemsItems.register(entity.getName() + "_spawn_egg", entity.getSpawnEgg()));
        Arrays.stream(WispTypes.values()).forEach(entity -> GemsItems.register(entity.getName() + "_spawn_egg", entity.getSpawnEgg()));
    }

    private static <T extends Item> T register(String name, T item) {
        ResourceLocation id = new ResourceLocation("silentgems", name);
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    private static void registerGemItems(Function<Gems, ? extends Item> factory, Function<Gems, String> name) {
        for (Gems gem : Gems.values()) {
            GemsItems.register(name.apply(gem), factory.apply(gem));
        }
    }

    static {
        BLOCKS_TO_REGISTER = new ArrayList<BlockItem>();
    }
}

