/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.EmptyLootEntry;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.PatchBlockChangerItem;
import net.silentchaos512.gems.loot.functions.SetSoulFunction;

@Mod.EventBusSubscriber(modid="silentgems")
public final class GemsLoot {
    public static final ResourceLocation RANDOM_GEMS = SilentGems.getId("random_gems");
    private static final Map<ResourceLocation, Integer> ADD_GEMS_TO = ImmutableMap.builder().put((Object)LootTables.field_186424_f, (Object)2).put((Object)LootTables.field_204312_r, (Object)4).put((Object)LootTables.field_186429_k, (Object)3).put((Object)LootTables.field_186421_c, (Object)2).put((Object)LootTables.field_186430_l, (Object)2).put((Object)LootTables.field_204773_u, (Object)2).put((Object)LootTables.field_186422_d, (Object)3).put((Object)LootTables.field_186427_i, (Object)4).put((Object)LootTables.field_191192_o, (Object)4).build();
    private static final List<ResourceLocation> ADD_RARE_ITEMS_TO = ImmutableList.of((Object)LootTables.field_186422_d, (Object)LootTables.field_215824_o, (Object)LootTables.field_186425_g, (Object)LootTables.field_186428_j, (Object)LootTables.field_186427_i, (Object)LootTables.field_215813_K);

    private GemsLoot() {
    }

    public static void init() {
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)SetSoulFunction.SERIALIZER);
        MinecraftForge.EVENT_BUS.addListener(GemsLoot::onLootTableLoad);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableName = event.getName();
        if (ADD_GEMS_TO.keySet().contains(tableName)) {
            GemsLoot.addGemsToTable(event, ADD_GEMS_TO.get(tableName));
        }
        if (ADD_RARE_ITEMS_TO.contains(tableName)) {
            GemsLoot.addRareItemsToTable(event);
        }
    }

    private static void addGemsToTable(LootTableLoadEvent event, int maxRolls) {
        if (GemsLoot.hasLootPool(event.getTable(), "silentgems_added_gems")) {
            return;
        }
        SilentGems.LOGGER.info("Add gems to loot table {} ({} rolls)", (Object)event.getName(), (Object)maxRolls);
        event.getTable().addPool(new LootPool.Builder().name("silentgems_added_gems").func_216046_a((IRandomRange)new RandomValueRange(1.0f, (float)maxRolls)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)RANDOM_GEMS).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(2.0f, 5.0f)))).func_216044_b());
    }

    private static void addRareItemsToTable(LootTableLoadEvent event) {
        if (GemsLoot.hasLootPool(event.getTable(), "silentgems_rare_items")) {
            return;
        }
        SilentGems.LOGGER.info("Add 'rare' items to loot table {}", (Object)event.getName());
        event.getTable().addPool(new LootPool.Builder().name("silentgems_rare_items").func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)PatchBlockChangerItem.CORRUPTING_POWDER.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)PatchBlockChangerItem.PURIFYING_POWDER.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 2.0f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(3)).func_216044_b());
    }

    private static boolean hasLootPool(LootTable table, String poolName) {
        return table.getPool(poolName) != null;
    }
}

