/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.crafting.ingredient.SoulElementIngredient;
import net.silentchaos512.gems.crafting.ingredient.SoulGemIngredient;
import net.silentchaos512.gems.crafting.recipe.ApplyChaosRuneRecipe;
import net.silentchaos512.gems.crafting.recipe.ApplyEnchantmentTokenRecipe;
import net.silentchaos512.gems.crafting.recipe.GearSoulRecipe;
import net.silentchaos512.gems.crafting.recipe.ModifySoulUrnRecipe;
import net.silentchaos512.gems.crafting.recipe.SoulUrnRecipe;
import net.silentchaos512.gems.crafting.tokenenchanter.TokenEnchanterRecipe;

public final class GemsRecipeInit {
    private GemsRecipeInit() {
    }

    public static void init() {
        SoulElementIngredient.Serializer.register();
        SoulGemIngredient.Serializer.register();
        GemsRecipeInit.registerRecipeType("token_enchanting", TokenEnchanterRecipe.RECIPE_TYPE);
        GemsRecipeInit.registerSerializer(SilentGems.getId("token_enchanting"), TokenEnchanterRecipe.SERIALIZER);
        GemsRecipeInit.registerSerializer(ApplyChaosRuneRecipe.NAME, ApplyChaosRuneRecipe.SERIALIZER);
        GemsRecipeInit.registerSerializer(ApplyEnchantmentTokenRecipe.NAME, ApplyEnchantmentTokenRecipe.SERIALIZER);
        GemsRecipeInit.registerSerializer(GearSoulRecipe.NAME, GearSoulRecipe.SERIALIZER);
        GemsRecipeInit.registerSerializer(ModifySoulUrnRecipe.NAME, ModifySoulUrnRecipe.SERIALIZER);
        GemsRecipeInit.registerSerializer(SoulUrnRecipe.NAME, SoulUrnRecipe.SERIALIZER);
        if (SilentGems.isDevBuild()) {
            // empty if block
        }
    }

    private static void registerSerializer(ResourceLocation name, IRecipeSerializer<?> serializer) {
        IRecipeSerializer.func_222156_a((String)name.toString(), serializer);
    }

    private static void registerRecipeType(String name, IRecipeType<?> recipeType) {
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)SilentGems.getId(name), recipeType);
    }

    private static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getPlayer().field_70170_p.func_73046_m() == null) {
            return;
        }
        ResourceLocation[] recipes = (ResourceLocation[])event.getPlayer().field_70170_p.func_73046_m().func_199529_aN().func_199510_b().stream().map(IRecipe::func_199560_c).filter(name -> name.func_110624_b().equals("silentgems")).toArray(ResourceLocation[]::new);
        SilentGems.LOGGER.info("DEV: Unlocking {} recipes in recipe book", (Object)recipes.length);
        event.getPlayer().func_193102_a(recipes);
    }
}

