/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.Locale;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.utils.Lazy;

public enum GemsSounds {
    SOUL_URN_LID(0.6f, 0.0f, 1.1f, 0.05f),
    SOUL_URN_OPEN(0.6f, 0.0f, 1.1f, 0.05f);

    final Lazy<SoundEvent> sound;
    final float volume;
    final float volumeVariation;
    final float pitch;
    final float pitchVariation;

    private GemsSounds(float volume, float volumeVariation, float pitch, float pitchVariation) {
        this.volume = volume;
        this.volumeVariation = volumeVariation;
        this.pitch = pitch;
        this.pitchVariation = pitchVariation;
        this.sound = Lazy.of(() -> {
            ResourceLocation id = new ResourceLocation("silentgems", this.getName());
            return new SoundEvent(id);
        });
    }

    public SoundEvent get() {
        return (SoundEvent)this.sound.get();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public void play(IWorld world, BlockPos pos) {
        float volume = this.volume + this.volumeVariation * (float)SilentGems.random.nextGaussian();
        float pitch = this.pitch + this.pitchVariation * (float)SilentGems.random.nextGaussian();
        this.play(world, pos, volume, pitch);
    }

    public void play(IWorld world, BlockPos pos, float volume, float pitch) {
        world.func_184133_a(null, pos, this.get(), SoundCategory.PLAYERS, volume, pitch);
    }

    public static void registerAll(RegistryEvent.Register<SoundEvent> event) {
        for (GemsSounds sound : GemsSounds.values()) {
            GemsSounds.register(sound.getName(), sound.get());
        }
    }

    private static void register(String name, SoundEvent sound) {
        ResourceLocation id = new ResourceLocation("silentgems", name);
        sound.setRegistryName(id);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
    }

    public static void playAllHotswapFix(PlayerEntity player) {
        for (GemsSounds sound : GemsSounds.values()) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), sound.get(), SoundCategory.PLAYERS, 0.05f, 1.0f);
        }
    }
}

