/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.block.altar.AltarBlock;
import net.silentchaos512.gems.block.altar.AltarTileEntity;
import net.silentchaos512.gems.block.flowerpot.LuminousFlowerPotBlock;
import net.silentchaos512.gems.block.flowerpot.LuminousFlowerPotTileEntity;
import net.silentchaos512.gems.block.flowerpot.PhantomLightBlock;
import net.silentchaos512.gems.block.flowerpot.PhantomLightTileEntity;
import net.silentchaos512.gems.block.pedestal.PedestalTileEntity;
import net.silentchaos512.gems.block.supercharger.SuperchargerBlock;
import net.silentchaos512.gems.block.supercharger.SuperchargerTileEntity;
import net.silentchaos512.gems.block.teleporter.GemTeleporterTileEntity;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterBlock;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterTileEntity;
import net.silentchaos512.gems.block.urn.SoulUrnBlock;
import net.silentchaos512.gems.block.urn.SoulUrnTileEntity;
import net.silentchaos512.gems.client.render.tile.PedestalRenderer;
import net.silentchaos512.gems.client.render.tile.SoulUrnRenderer;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.utils.Lazy;

public enum GemsTileEntities {
    CHAOS_FLOWER_POT(LuminousFlowerPotTileEntity::new, () -> LuminousFlowerPotBlock.INSTANCE.get()),
    PEDESTAL(PedestalTileEntity::new, GemsBlocks.pedestals),
    PHANTOM_LIGHT(PhantomLightTileEntity::new, () -> PhantomLightBlock.INSTANCE.get()),
    SOUL_URN(SoulUrnTileEntity::new, () -> SoulUrnBlock.INSTANCE.get()),
    SUPERCHARGER(SuperchargerTileEntity::new, () -> SuperchargerBlock.INSTANCE.get()),
    TELEPORTER(GemTeleporterTileEntity::new, GemsBlocks.teleporters),
    TOKEN_ENCHANTER(TokenEnchanterTileEntity::new, () -> TokenEnchanterBlock.INSTANCE.get()),
    TRANSMUTATION_ALTAR(AltarTileEntity::new, () -> AltarBlock.INSTANCE.get());

    private final Lazy<TileEntityType<?>> type;

    private GemsTileEntities(Supplier<TileEntity> factory, Supplier<? extends Block> block) {
        this.type = Lazy.of(() -> TileEntityType.Builder.func_223042_a((Supplier)factory, (Block[])new Block[]{(Block)block.get()}).func_206865_a(null));
    }

    private GemsTileEntities(Supplier<TileEntity> factory, List<? extends Block> blocks) {
        this.type = Lazy.of(() -> TileEntityType.Builder.func_223042_a((Supplier)factory, (Block[])blocks.toArray(new Block[0])).func_206865_a(null));
    }

    public TileEntityType<?> type() {
        return (TileEntityType)this.type.get();
    }

    public static void registerAll(RegistryEvent.Register<TileEntityType<?>> event) {
        for (GemsTileEntities tileEnum : GemsTileEntities.values()) {
            GemsTileEntities.register(tileEnum.name().toLowerCase(Locale.ROOT), tileEnum.type());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(PedestalTileEntity.class, (TileEntityRenderer)new PedestalRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SoulUrnTileEntity.class, (TileEntityRenderer)new SoulUrnRenderer());
    }

    private static <T extends TileEntity> void register(String name, TileEntityType<T> type) {
        ResourceLocation id = new ResourceLocation("silentgems", name);
        type.setRegistryName(id);
        ForgeRegistries.TILE_ENTITIES.register(type);
    }
}

