/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.ClientPlayerInfo;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.utils.Lazy;

public class ChaosMeterItem
extends Item {
    public static final Lazy<ChaosMeterItem> INSTANCE = Lazy.of(ChaosMeterItem::new);
    private static final String NBT_PLAYER_MODE = "ChaosMeter.PlayerMode";

    public ChaosMeterItem() {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY).func_200917_a(1));
        this.func_185043_a(SilentGems.getId("chaos_level"), (stack, world, entity) -> ChaosMeterItem.getChaosLevel(stack));
    }

    private static int getChaosLevel(ItemStack stack) {
        return ChaosMeterItem.isPlayerMode(stack) ? ClientPlayerInfo.playerChaos : ClientPlayerInfo.worldChaos;
    }

    private static boolean isPlayerMode(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(NBT_PLAYER_MODE);
    }

    private static void setPlayerMode(ItemStack stack, boolean playerMode) {
        stack.func_196082_o().func_74757_a(NBT_PLAYER_MODE, playerMode);
    }

    private static ITextComponent formatValue(int value, boolean playerMode) {
        TranslationTextComponent typeText = new TranslationTextComponent("misc.silentgems." + (playerMode ? "player" : "world"), new Object[0]);
        String valueStr = String.format("%,d", value);
        return new TranslationTextComponent("item.silentgems.chaos_meter.valueFormat", new Object[]{typeText, valueStr});
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            boolean playerMode = ChaosMeterItem.isPlayerMode(heldItem);
            ChaosMeterItem.setPlayerMode(heldItem, !playerMode);
        }
        int chaos = ChaosMeterItem.getChaosLevel(heldItem);
        playerIn.func_146105_b(ChaosMeterItem.formatValue(chaos, ChaosMeterItem.isPlayerMode(heldItem)), true);
        return new ActionResult(ActionResultType.PASS, (Object)heldItem);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean playerMode = ChaosMeterItem.isPlayerMode(stack);
        TranslationTextComponent mode = new TranslationTextComponent("misc.silentgems." + (playerMode ? "player" : "world"), new Object[0]);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.silentgems.chaos_meter.mode", new Object[]{mode}));
    }
}

