/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsItemGroups;

public class ChaosOrbItem
extends Item {
    private final int maxAbsorb;
    private final int crackStages;
    private final float leakage;

    public ChaosOrbItem(int crackStages, int maxAbsorb, float leakage) {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY).func_200917_a(1).func_200915_b(maxAbsorb).setNoRepair());
        this.maxAbsorb = maxAbsorb;
        this.crackStages = crackStages;
        this.leakage = leakage;
        this.func_185043_a(SilentGems.getId("crack_stage"), (stack, world, entity) -> ChaosOrbItem.getCrackStage(stack));
    }

    public static int absorbChaos(LivingEntity entity, ItemStack stack, int amount) {
        int newCrackStage;
        if (!(stack.func_77973_b() instanceof ChaosOrbItem)) {
            return 0;
        }
        ChaosOrbItem item = (ChaosOrbItem)stack.func_77973_b();
        int toAbsorb = ChaosOrbItem.getChaosToAbsorb(amount, item);
        int crackStage = ChaosOrbItem.getCrackStage(stack);
        if (stack.func_96631_a(toAbsorb, entity.func_70681_au(), entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null)) {
            ChaosOrbItem.destroyOrb(entity, stack);
        }
        if (!stack.func_190926_b() && (newCrackStage = ChaosOrbItem.getCrackStage(stack)) != crackStage) {
            ChaosOrbItem.notifyOrbCracked(entity, stack);
        }
        return amount - toAbsorb;
    }

    public static int absorbChaos(IWorld world, BlockPos pos, ItemStack stack, int amount) {
        int newCrackStage;
        if (!(stack.func_77973_b() instanceof ChaosOrbItem)) {
            return 0;
        }
        ChaosOrbItem item = (ChaosOrbItem)stack.func_77973_b();
        int toAbsorb = ChaosOrbItem.getChaosToAbsorb(amount, item);
        int crackStage = ChaosOrbItem.getCrackStage(stack);
        if (stack.func_96631_a(toAbsorb, SilentGems.random, null)) {
            ChaosOrbItem.destroyOrb(world, pos, stack);
        }
        if (!stack.func_190926_b() && (newCrackStage = ChaosOrbItem.getCrackStage(stack)) != crackStage) {
            ChaosOrbItem.playBreakSound(world, pos);
        }
        return amount - toAbsorb;
    }

    private static int getChaosToAbsorb(int amount, ChaosOrbItem item) {
        return (int)((float)amount * (1.0f - item.leakage));
    }

    private static void notifyOrbCracked(LivingEntity entity, ItemStack stack) {
        entity.func_145747_a((ITextComponent)new TranslationTextComponent("item.silentgems.chaos_orb.crack", new Object[]{stack.func_200301_q()}));
        ChaosOrbItem.playCrackSound((IWorld)entity.field_70170_p, entity.func_180425_c());
    }

    private static void destroyOrb(LivingEntity entity, ItemStack stack) {
        ITextComponent displayName = stack.func_200301_q();
        entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187635_cQ, entity.func_184176_by(), 0.8f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f, false);
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71029_a(Stats.field_199088_e.func_199076_b((Object)stack.func_77973_b()));
        }
        ChaosOrbItem.destroyOrb((IWorld)entity.field_70170_p, entity.func_180425_c(), stack);
        int pieceCount = entity.func_70681_au().nextInt(99000) + 1000;
        String piecesFormatted = String.format("%,d", pieceCount);
        entity.func_145747_a((ITextComponent)new TranslationTextComponent("item.silentgems.chaos_orb.break", new Object[]{displayName, piecesFormatted}));
    }

    private static void destroyOrb(IWorld world, BlockPos pos, ItemStack stack) {
        stack.func_190918_g(1);
        stack.func_196085_b(0);
        ChaosOrbItem.playBreakSound(world, pos);
    }

    private static void playCrackSound(IWorld world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.AMBIENT, 0.6f, 1.5f);
    }

    private static void playBreakSound(IWorld world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.AMBIENT, 0.7f, -2.5f);
    }

    public static int getChaosAbsorbed(ItemStack stack) {
        return stack.func_77952_i();
    }

    public static int getCrackStage(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ChaosOrbItem)) {
            return 0;
        }
        ChaosOrbItem item = (ChaosOrbItem)stack.func_77973_b();
        float ratio = (float)ChaosOrbItem.getChaosAbsorbed(stack) / (float)item.maxAbsorb;
        return MathHelper.func_76125_a((int)((int)(ratio * (float)(item.crackStages + 1))), (int)0, (int)item.crackStages);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.silentgems.chaos_orb.leakage", new Object[]{(int)(100.0f * this.leakage)}));
    }
}

