/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.api.chaos.ChaosEmissionRate;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.lib.chaosbuff.ChaosBuffManager;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.gems.lib.chaosbuff.PotionChaosBuff;
import net.silentchaos512.utils.Lazy;

public final class ChaosRuneItem
extends Item {
    public static final Lazy<ChaosRuneItem> INSTANCE = Lazy.of(ChaosRuneItem::new);
    private static final String NBT_KEY = "SGems_BuffRune";

    private ChaosRuneItem() {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY));
    }

    @Deprecated
    public static ItemStack getStack(IChaosBuff buff) {
        return ChaosRuneItem.getStack(buff.getId());
    }

    public static ItemStack getStack(ResourceLocation buffId) {
        ItemStack result = new ItemStack((IItemProvider)INSTANCE.get());
        result.func_196082_o().func_74778_a(NBT_KEY, buffId.toString());
        return result;
    }

    @Nullable
    public static IChaosBuff getBuff(ItemStack stack) {
        String string = stack.func_196082_o().func_74779_i(NBT_KEY);
        return ChaosBuffManager.get(string);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        IChaosBuff buff = ChaosRuneItem.getBuff(stack);
        if (buff == null) {
            return 0xFFFFFF;
        }
        return buff.getRuneColor();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IChaosBuff buff = ChaosRuneItem.getBuff(stack);
        if (buff != null) {
            ITextComponent buffName = buff.getDisplayName(0);
            return new TranslationTextComponent(this.func_77658_a() + ".nameProper", new Object[]{buffName});
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IChaosBuff buff = ChaosRuneItem.getBuff(stack);
        if (buff == null) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".maxLevel", new Object[]{buff.getMaxLevel()}));
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".slotsUsed", new Object[]{buff.getSlotsForLevel(1)}));
        int activeChaosGenerated = buff.getActiveChaosGenerated(1);
        ChaosEmissionRate emissionRate = ChaosEmissionRate.fromAmount(activeChaosGenerated);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".chaos", new Object[]{emissionRate.getDisplayName(activeChaosGenerated)}));
        if (KeyTracker.isAltDown()) {
            tooltip.add(new StringTextComponent(String.format("Buff ID: %s", buff.getId())).func_211708_a(TextFormatting.DARK_GRAY));
            tooltip.add(new StringTextComponent(String.format("Color: %X", buff.getRuneColor())).func_211708_a(TextFormatting.DARK_GRAY));
            if (buff instanceof PotionChaosBuff) {
                Effect effect = ((PotionChaosBuff)buff).getEffect();
                tooltip.add(new StringTextComponent(String.format("Effect: %s", effect)).func_211708_a(TextFormatting.DARK_GRAY));
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        for (IChaosBuff buff : ChaosBuffManager.getValues()) {
            items.add((Object)ChaosRuneItem.getStack(buff.getId()));
        }
    }
}

