/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.utils.Lazy;

public enum CraftingItems implements IItemProvider,
IStringSerializable
{
    CHAOS_CRYSTAL,
    ENRICHED_CHAOS_CRYSTAL,
    CHAOS_CRYSTAL_SHARD,
    CHAOS_DUST,
    ENDER_CRYSTAL,
    ENDER_CRYSTAL_SHARD,
    ENDER_FROST,
    NETHER_STAR_SHARD,
    SILVER_INGOT,
    SILVER_NUGGET,
    CHAOS_IRON_UNFIRED,
    CHAOS_IRON,
    CHARGING_AGENT,
    SUPER_CHARGING_AGENT,
    ULTRA_CHARGING_AGENT,
    CHAOS_COAL,
    ENDER_SLIMEBALL,
    FLUFFY_PUFF,
    ORNATE_GOLD_ROD,
    ORNATE_SILVER_ROD,
    GILDED_STRING,
    GILDED_BOWSTRING,
    BLANK_TOKEN,
    RUNE_SLATE,
    SOUL_SHELL,
    MYSTERY_GOO,
    IRON_POTATO,
    FLUFFY_FABRIC,
    URN_UPGRADE_BASE,
    LOLINOMICON(false);

    private final Lazy<ItemCrafting> item = Lazy.of(() -> new ItemCrafting());
    private final boolean shownInGroup;

    private CraftingItems() {
        this(true);
    }

    private CraftingItems(boolean shownInGroup) {
        this.shownInGroup = shownInGroup;
    }

    public Item func_199767_j() {
        return (Item)this.item.get();
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ItemStack getStack() {
        return this.getStack(1);
    }

    public ItemStack getStack(int count) {
        return new ItemStack((IItemProvider)this, count);
    }

    final class ItemCrafting
    extends Item {
        private ItemCrafting() {
            super(new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS));
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            tooltip.add(new TranslationTextComponent("item.silentgems.crafting_material.desc", new Object[0]).func_211708_a(TextFormatting.GOLD));
            String descKey = this.func_77658_a() + ".desc";
            if (I18n.func_188566_a((String)descKey)) {
                tooltip.add(new TranslationTextComponent(descKey, new Object[0]).func_211708_a(TextFormatting.ITALIC));
            }
        }

        public int getBurnTime(ItemStack itemStack) {
            if (itemStack.func_77973_b() == CHAOS_COAL.func_199767_j()) {
                return (Integer)GemsConfig.COMMON.chaosCoalBurnTime.get();
            }
            return 0;
        }

        public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
            if (!CraftingItems.this.shownInGroup || !this.func_194125_a(group)) {
                return;
            }
            super.func_150895_a(group, items);
        }
    }
}

