/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.Lazy;
import net.silentchaos512.utils.MathUtils;

public enum ModFoods implements IItemProvider,
IStringSerializable
{
    POTATO_ON_A_STICK(SGFoodItem.Builder.access$200(SGFoodItem.Builder.access$100(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(8).func_221454_a(0.8f).func_221453_d()), (IItemProvider)Items.field_151055_y), Effects.field_76420_g, TimeUtils.ticksFromSeconds((float)45.0f))),
    SUGAR_COOKIE(SGFoodItem.Builder.access$200(SGFoodItem.Builder.access$200(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(2).func_221454_a(0.4f).func_221455_b().func_221453_d()), Effects.field_76424_c, TimeUtils.ticksFromSeconds((float)30.0f)), Effects.field_76422_e, TimeUtils.ticksFromSeconds((float)30.0f))),
    SECRET_DONUT(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(6).func_221454_a(0.8f).func_221453_d())),
    UNCOOKED_MEATY_STEW(SGFoodItem.Builder.access$100(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(4).func_221454_a(0.6f).func_221453_d()), (IItemProvider)Items.field_151054_z)),
    MEATY_STEW(SGFoodItem.Builder.access$100(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(12).func_221454_a(1.6f).func_221453_d()), (IItemProvider)Items.field_151054_z)),
    UNCOOKED_FISHY_STEW(SGFoodItem.Builder.access$100(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(4).func_221454_a(0.5f).func_221453_d()), (IItemProvider)Items.field_151054_z)),
    FISHY_STEW(SGFoodItem.Builder.access$100(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(10).func_221454_a(1.2f).func_221453_d()), (IItemProvider)Items.field_151054_z)),
    CANDY_CANE(SGFoodItem.Builder.access$200(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(2).func_221454_a(0.2f).func_221457_c().func_221455_b().func_221453_d()), Effects.field_76428_l, TimeUtils.ticksFromSeconds((float)5.0f))),
    CUP_OF_COFFEE(SGFoodItem.Builder.access$200(SGFoodItem.Builder.access$200(SGFoodItem.Builder.access$300(SGFoodItem.Builder.access$000().food(new Food.Builder().func_221456_a(1).func_221454_a(0.2f).func_221455_b().func_221453_d())), Effects.field_76424_c, TimeUtils.ticksFromSeconds((float)60.0f)), Effects.field_76422_e, TimeUtils.ticksFromSeconds((float)30.0f)));

    private final Lazy<SGFoodItem> item = Lazy.of(() -> new SGFoodItem(this, builder));

    private ModFoods(SGFoodItem.Builder builder) {
    }

    public Item func_199767_j() {
        return (Item)this.item.get();
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static final class SGFoodItem
    extends Item {
        private static final List<Consumer<PlayerEntity>> SECRET_DONUT_EFFECTS = ImmutableList.of(SGFoodItem.addEffect(Effects.field_76440_q, TimeUtils.ticksFromSeconds((float)15.0f)), SGFoodItem.addEffect(Effects.field_76431_k, TimeUtils.ticksFromSeconds((float)15.0f)), SGFoodItem.addEffect(Effects.field_76420_g, TimeUtils.ticksFromSeconds((float)30.0f)), SGFoodItem.addEffect(Effects.field_76419_f, TimeUtils.ticksFromSeconds((float)60.0f)), SGFoodItem.addEffect(Effects.field_76422_e, TimeUtils.ticksFromSeconds((float)60.0f)), SGFoodItem.addEffect(Effects.field_76426_n, TimeUtils.ticksFromSeconds((float)120.0f)), SGFoodItem.addEffect(Effects.field_76438_s, TimeUtils.ticksFromSeconds((float)15.0f)), SGFoodItem.addEffect(Effects.field_76441_p, TimeUtils.ticksFromSeconds((float)30.0f)), SGFoodItem.addEffect(Effects.field_76430_j, TimeUtils.ticksFromSeconds((float)45.0f)), SGFoodItem.addEffect(Effects.field_76421_d, TimeUtils.ticksFromSeconds((float)60.0f)), SGFoodItem.addEffect(Effects.field_76424_c, TimeUtils.ticksFromSeconds((float)75.0f)), SGFoodItem.addEffect(Effects.field_76439_r, TimeUtils.ticksFromSeconds((float)60.0f)), (Object[])new Consumer[]{SGFoodItem.addEffect(Effects.field_76436_u, TimeUtils.ticksFromSeconds((float)10.0f)), SGFoodItem.addEffect(Effects.field_76428_l, TimeUtils.ticksFromSeconds((float)15.0f)), SGFoodItem.addEffect(Effects.field_76429_m, TimeUtils.ticksFromSeconds((float)15.0f)), SGFoodItem.addEffect(Effects.field_76427_o, TimeUtils.ticksFromSeconds((float)90.0f)), SGFoodItem.addEffect(Effects.field_76437_t, TimeUtils.ticksFromSeconds((float)45.0f)), SGFoodItem.addEffect(Effects.field_82731_v, TimeUtils.ticksFromSeconds((float)10.0f)), SGFoodItem.addEffect(Effects.field_188423_x, TimeUtils.ticksFromSeconds((float)30.0f)), SGFoodItem.addEffect(Effects.field_206827_D, TimeUtils.ticksFromSeconds((float)30.0f)), SGFoodItem.addEffect(Effects.field_188425_z, TimeUtils.ticksFromSeconds((float)120.0f)), SGFoodItem.addEffect(Effects.field_189112_A, TimeUtils.ticksFromSeconds((float)120.0f)), p -> p.func_70015_d(5), p -> p.func_70691_i((float)SilentGems.random.nextInt(10)), p -> p.func_70097_a(DamageSource.field_76367_g, (float)SilentGems.random.nextInt(5))});
        private static final float SECRET_DONUT_EFFECT_CHANCE = 0.33f;
        private static final float SECRET_DONUT_TEXT_CHANCE = 0.66f;
        private static int donutMessageCount;
        private final ModFoods foodType;
        private final UseAction useAction;
        @Nullable
        private final IItemProvider returnItem;
        private final Collection<EffectInstance> potionEffects = new ArrayList<EffectInstance>();

        SGFoodItem(ModFoods foodType, Builder builder) {
            super((Item.Properties)builder);
            this.foodType = foodType;
            this.returnItem = builder.returnItem;
            this.useAction = builder.useAction;
            this.potionEffects.addAll(builder.potionEffects);
        }

        public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
            ItemStack result = super.func_77654_b(stack, worldIn, entity);
            if (worldIn.field_72995_K || !(entity instanceof PlayerEntity)) {
                return result;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (this.returnItem != null) {
                PlayerUtils.giveItem((PlayerEntity)player, (ItemStack)new ItemStack(this.returnItem));
            }
            this.potionEffects.forEach(effect -> {
                EffectInstance effect1 = new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), true, false);
                player.func_195064_c(effect1);
            });
            if (this.foodType == SECRET_DONUT) {
                SGFoodItem.onSecretDonutEaten(stack, worldIn, player);
            }
            return result;
        }

        private static Consumer<PlayerEntity> addEffect(Effect effect, int duration) {
            return player -> player.func_195064_c(new EffectInstance(effect, duration, 0, true, false));
        }

        private static void onSecretDonutEaten(ItemStack stack, World world, PlayerEntity player) {
            Random random = SilentGems.random;
            if (MathUtils.tryPercentage((Random)random, (double)0.33f)) {
                SGFoodItem.addSecretDonutEffect(world, player);
                if (MathUtils.tryPercentage((Random)random, (double)0.33f)) {
                    SGFoodItem.addSecretDonutEffect(world, player);
                    if (MathUtils.tryPercentage((Random)random, (double)0.33f)) {
                        SGFoodItem.addSecretDonutEffect(world, player);
                    }
                }
            }
            if (MathUtils.tryPercentage((Random)random, (double)0.66f)) {
                String key = "donut.silentgems." + MathUtils.nextIntInclusive((int)1, (int)8);
                player.func_145747_a((ITextComponent)new TranslationTextComponent(key, new Object[0]));
            }
        }

        private static void addSecretDonutEffect(World world, PlayerEntity player) {
            SECRET_DONUT_EFFECTS.get(SilentGems.random.nextInt(SECRET_DONUT_EFFECTS.size())).accept(player);
        }

        public UseAction func_77661_b(ItemStack stack) {
            return this.useAction;
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            tooltip.add(new TranslationTextComponent(this.func_77658_a() + ".desc", new Object[0]).func_211708_a(TextFormatting.ITALIC));
        }

        private static final class Builder
        extends Item.Properties {
            @Nullable
            private IItemProvider returnItem;
            private UseAction useAction = UseAction.EAT;
            private final Collection<EffectInstance> potionEffects = new ArrayList<EffectInstance>();

            private Builder() {
            }

            private static Builder create() {
                Builder builder = new Builder();
                builder.func_200916_a(GemsItemGroups.UTILITY);
                return builder;
            }

            public Builder food(Food foodIn) {
                return (Builder)super.func_221540_a(foodIn);
            }

            private Builder setReturnItem(IItemProvider returnItem) {
                this.returnItem = returnItem;
                return this;
            }

            private Builder setActionToDrink() {
                this.useAction = UseAction.DRINK;
                return this;
            }

            private Builder addEffect(Effect effect, int duration) {
                this.potionEffects.add(new EffectInstance(effect, duration, 0));
                return this;
            }

            static /* synthetic */ Builder access$000() {
                return Builder.create();
            }

            static /* synthetic */ Builder access$100(Builder x0, IItemProvider x1) {
                return x0.setReturnItem(x1);
            }

            static /* synthetic */ Builder access$200(Builder x0, Effect x1, int x2) {
                return x0.addEffect(x1, x2);
            }

            static /* synthetic */ Builder access$300(Builder x0) {
                return x0.setActionToDrink();
            }
        }
    }
}

