/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.SoulUrnBlock;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.item.ReturnHomeCharmItem;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.Gems;

public final class ColorHandlers {
    private ColorHandlers() {
    }

    public static void onBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        SilentGems.LOGGER.info("ColorHandlers#onBlockColors: {}", (Object)colors);
        if (colors == null) {
            SilentGems.LOGGER.error("BlockColors is null?", (Throwable)new IllegalStateException("wat?"));
            return;
        }
        ColorHandlers.registerBlocks(colors, SoulUrnBlock::getBlockColor, (Block)SoulUrnBlock.INSTANCE.get());
    }

    public static void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        SilentGems.LOGGER.info("ColorHandlers#onItemColors: {}", (Object)colors);
        if (colors == null) {
            SilentGems.LOGGER.error("ItemColors is null?", (Throwable)new IllegalStateException("wat?"));
            return;
        }
        ColorHandlers.registerItems(colors, SoulUrnBlock::getItemColor, (IItemProvider)SoulUrnBlock.INSTANCE.get());
        ColorHandlers.registerItems(colors, EnchantmentTokenItem::getItemColor, (IItemProvider)EnchantmentTokenItem.INSTANCE.get());
        ColorHandlers.registerItems(colors, ReturnHomeCharmItem::getColor, (IItemProvider[])Arrays.stream(Gems.values()).map(Gems::getReturnHomeCharm).toArray(IItemProvider[]::new));
        ColorHandlers.registerItems(colors, ChaosRuneItem::getColor, (IItemProvider)ChaosRuneItem.INSTANCE.get());
        ColorHandlers.registerItems(colors, SoulGemItem::getColor, (IItemProvider)SoulGemItem.INSTANCE.get());
        ColorHandlers.registerItems(colors, GearSoulItem::getColor, (IItemProvider)GearSoulItem.INSTANCE.get());
    }

    private static void registerBlocks(BlockColors handler, IBlockColor blockColor, Block ... blocks) {
        try {
            handler.func_186722_a(blockColor, blocks);
        }
        catch (NullPointerException ex) {
            SilentGems.LOGGER.error("Something went horribly wrong when registering block colors (Forge bug?)", (Throwable)ex);
        }
    }

    private static void registerItems(ItemColors handler, IItemColor itemColor, IItemProvider ... items) {
        try {
            handler.func_199877_a(itemColor, items);
        }
        catch (NullPointerException ex) {
            SilentGems.LOGGER.error("Something went horribly wrong when registering item colors (Forge bug?)", (Throwable)ex);
        }
    }
}

