/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.GemBlock;
import net.silentchaos512.gems.block.GemBricksBlock;
import net.silentchaos512.gems.block.GemGlassBlock;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.GemOreBlock;
import net.silentchaos512.gems.block.GlowroseBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MultiGemOreBlock;
import net.silentchaos512.gems.block.PottedGlowroseBlock;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.RedstoneGemTeleporterBlock;
import net.silentchaos512.gems.item.ChaosGemItem;
import net.silentchaos512.gems.item.GemItem;
import net.silentchaos512.gems.item.GemShardItem;
import net.silentchaos512.gems.item.ReturnHomeCharmItem;
import net.silentchaos512.gems.lib.IGem;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.Lazy;

public enum Gems implements IStringSerializable
{
    RUBY(Set.CLASSIC, 15080733),
    GARNET(Set.CLASSIC, 15093533),
    TOPAZ(Set.CLASSIC, 15102237),
    AMBER(Set.CLASSIC, 15115037),
    HELIODOR(Set.CLASSIC, 15123741),
    PERIDOT(Set.CLASSIC, 10741277),
    GREEN_SAPPHIRE(Set.CLASSIC, 1959453),
    PHOSPHOPHYLLITE(Set.CLASSIC, 1959554),
    AQUAMARINE(Set.CLASSIC, 1959654),
    SAPPHIRE(Set.CLASSIC, 1908198),
    TANZANITE(Set.CLASSIC, 6299110),
    AMETHYST(Set.CLASSIC, 10690022),
    AGATE(Set.CLASSIC, 15080934),
    MORGANITE(Set.CLASSIC, 0xFF88FE),
    ONYX(Set.CLASSIC, 0x2F2F2F),
    OPAL(Set.CLASSIC, 0xE4E4E4),
    CARNELIAN(Set.DARK, 10685952),
    SPINEL(Set.DARK, 10699776),
    CITRINE(Set.DARK, 10706688),
    JASPER(Set.DARK, 10717184),
    ZIRCON(Set.DARK, 0xA3A300),
    MOLDAVITE(Set.DARK, 8954624),
    MALACHITE(Set.DARK, 41782),
    TURQUOISE(Set.DARK, 41864),
    EUCLASE(Set.DARK, 28067),
    BENITOITE(Set.DARK, 7075),
    IOLITE(Set.DARK, 6226083),
    ALEXANDRITE(Set.DARK, 9765027),
    LEPIDOLITE(Set.DARK, 10682490),
    AMETRINE(Set.DARK, 10682450),
    BLACK_DIAMOND(Set.DARK, 0x1E1E1E),
    MOONSTONE(Set.DARK, 0x898989),
    PYROPE(Set.LIGHT, 16729460),
    CORAL(Set.LIGHT, 0xFF5545),
    SUNSTONE(Set.LIGHT, 16741445),
    CATS_EYE(Set.LIGHT, 16761157),
    YELLOW_DIAMOND(Set.LIGHT, 0xFFFF45),
    JADE(Set.LIGHT, 10682181),
    CHRYSOPRASE(Set.LIGHT, 6618949),
    APATITE(Set.LIGHT, 4587473),
    FLUORITE(Set.LIGHT, 4575743),
    KYANITE(Set.LIGHT, 4555775),
    SODALITE(Set.LIGHT, 0x5445FF),
    AMMOLITE(Set.LIGHT, 14697983),
    KUNZITE(Set.LIGHT, 16729568),
    ROSE_QUARTZ(Set.LIGHT, 16742582),
    TEKTITE(Set.LIGHT, 9403499),
    PEARL(Set.LIGHT, 14870769);

    final Set set;
    final Color color;
    final Lazy<GemOreBlock> ore;
    final Lazy<GemBlock> block;
    final Lazy<GemBricksBlock> bricks;
    final Lazy<GemGlassBlock> glass;
    final Lazy<GemLampBlock> lampUnlit;
    final Lazy<GemLampBlock> lampLit;
    final Lazy<GemLampBlock> lampInvertedLit;
    final Lazy<GemLampBlock> lampInvertedUnlit;
    final Lazy<GemTeleporterBlock> teleporter;
    final Lazy<RedstoneGemTeleporterBlock> redstoneTeleporter;
    final Lazy<GlowroseBlock> glowrose;
    final Lazy<FlowerPotBlock> pottedGlowrose;
    final Lazy<GemItem> item;
    final Lazy<GemShardItem> shard;
    final Lazy<ReturnHomeCharmItem> returnHomeCharm;
    final Lazy<ChaosGemItem> chaosGem;
    final Tag<Block> blockTag;
    final Tag<Block> glowroseTag;
    final Tag<Item> itemTag;
    final Tag<Item> shardTag;

    private Gems(Set set, int color) {
        this.set = set;
        this.set.gems.add(this);
        this.color = new Color(color);
        this.ore = Lazy.of(() -> new GemOreBlock(this));
        this.block = Lazy.of(() -> new GemBlock(this));
        this.bricks = Lazy.of(() -> new GemBricksBlock(this));
        this.glass = Lazy.of(() -> new GemGlassBlock(this));
        this.lampUnlit = Lazy.of(() -> new GemLampBlock(this, GemLampBlock.State.UNLIT));
        this.lampLit = Lazy.of(() -> new GemLampBlock(this, GemLampBlock.State.LIT));
        this.lampInvertedLit = Lazy.of(() -> new GemLampBlock(this, GemLampBlock.State.INVERTED_LIT));
        this.lampInvertedUnlit = Lazy.of(() -> new GemLampBlock(this, GemLampBlock.State.INVERTED_UNLIT));
        this.teleporter = Lazy.of(() -> new GemTeleporterBlock(this, false));
        this.redstoneTeleporter = Lazy.of(() -> new RedstoneGemTeleporterBlock(this, false));
        this.glowrose = Lazy.of(() -> new GlowroseBlock(this));
        this.pottedGlowrose = Lazy.of(() -> new PottedGlowroseBlock((GlowroseBlock)this.glowrose.get()));
        this.item = Lazy.of(() -> new GemItem(this));
        this.shard = Lazy.of(() -> new GemShardItem(this));
        this.returnHomeCharm = Lazy.of(() -> new ReturnHomeCharmItem(this));
        this.chaosGem = Lazy.of(() -> new ChaosGemItem(this));
        this.blockTag = new BlockTags.Wrapper(new ResourceLocation("forge", "storage_blocks/" + this.func_176610_l()));
        this.glowroseTag = new BlockTags.Wrapper(new ResourceLocation("silentgems", "glowroses/" + this.func_176610_l()));
        this.itemTag = new ItemTags.Wrapper(new ResourceLocation("forge", "gems/" + this.func_176610_l()));
        this.shardTag = new ItemTags.Wrapper(new ResourceLocation("forge", "nuggets/" + this.func_176610_l()));
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int getColor() {
        return this.color.getColor();
    }

    public Color getColorObj() {
        return this.color;
    }

    public float[] getColorArray() {
        return new float[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()};
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("gem.silentgems." + this.func_176610_l(), new Object[0]);
    }

    @Nullable
    public static Gems from(ItemStack stack) {
        return Gems.from(stack, true);
    }

    @Nullable
    public static Gems from(ItemStack stack, boolean matchTag) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof IGem) {
                return ((IGem)item).getGem();
            }
            if (matchTag) {
                for (Gems gem : Gems.values()) {
                    if (!gem.itemTag.func_199685_a_((Object)item)) continue;
                    return gem;
                }
            }
        }
        return null;
    }

    @Nullable
    public static Gems fromName(String name) {
        for (Gems gem : Gems.values()) {
            if (!name.equalsIgnoreCase(gem.name())) continue;
            return gem;
        }
        return null;
    }

    public static Gems selectRandom() {
        return Gems.selectRandom(SilentGems.random);
    }

    public static Gems selectRandom(Random random) {
        return Gems.values()[random.nextInt(Gems.values().length)];
    }

    public GemBlock getBlock() {
        return (GemBlock)((Object)this.block.get());
    }

    public GemBricksBlock getBricks() {
        return (GemBricksBlock)((Object)this.bricks.get());
    }

    public GemGlassBlock getGlass() {
        return (GemGlassBlock)((Object)this.glass.get());
    }

    public GemLampBlock getLamp(GemLampBlock.State state) {
        if (state == GemLampBlock.State.UNLIT) {
            return (GemLampBlock)((Object)this.lampUnlit.get());
        }
        if (state == GemLampBlock.State.LIT) {
            return (GemLampBlock)((Object)this.lampLit.get());
        }
        if (state == GemLampBlock.State.INVERTED_LIT) {
            return (GemLampBlock)((Object)this.lampInvertedLit.get());
        }
        if (state == GemLampBlock.State.INVERTED_UNLIT) {
            return (GemLampBlock)((Object)this.lampInvertedUnlit.get());
        }
        throw new IllegalArgumentException("Unknown GemLampBlock.State: " + (Object)((Object)state));
    }

    public GemOreBlock getOre() {
        return (GemOreBlock)this.ore.get();
    }

    public GlowroseBlock getGlowrose() {
        return (GlowroseBlock)this.glowrose.get();
    }

    public FlowerPotBlock getPottedGlowrose() {
        return (FlowerPotBlock)this.pottedGlowrose.get();
    }

    public GemTeleporterBlock getTeleporter() {
        return (GemTeleporterBlock)((Object)this.teleporter.get());
    }

    public RedstoneGemTeleporterBlock getRedstoneTeleporter() {
        return (RedstoneGemTeleporterBlock)((Object)this.redstoneTeleporter.get());
    }

    public GemItem getItem() {
        return (GemItem)this.item.get();
    }

    public ItemStack getItemStack() {
        return new ItemStack((IItemProvider)this.item.get());
    }

    public Tag<Block> getBlockTag() {
        return this.blockTag;
    }

    public Tag<Item> getItemTag() {
        return this.itemTag;
    }

    public Tag<Item> getShardTag() {
        return this.shardTag;
    }

    public GemShardItem getShard() {
        return (GemShardItem)this.shard.get();
    }

    public ReturnHomeCharmItem getReturnHomeCharm() {
        return (ReturnHomeCharmItem)this.returnHomeCharm.get();
    }

    public ChaosGemItem getChaosGem() {
        return (ChaosGemItem)this.chaosGem.get();
    }

    public Set getSet() {
        return this.set;
    }

    public static enum Set implements Iterable<Gems>
    {
        CLASSIC(0, HardenedRock.STONE),
        DARK(16, HardenedRock.NETHERRACK),
        LIGHT(32, HardenedRock.END_STONE);

        private final int startMeta;
        private final MultiGemOreBlock multiOre;
        private final IBlockProvider geodeShell;
        private final Collection<Gems> gems = new ArrayList<Gems>();

        private Set(int startMeta, IBlockProvider geodeShell) {
            this.startMeta = startMeta;
            this.multiOre = new MultiGemOreBlock(this);
            this.geodeShell = geodeShell;
        }

        public static Set forDimension(int dimension) {
            if (dimension == -1) {
                return DARK;
            }
            if (dimension == 1) {
                return LIGHT;
            }
            return CLASSIC;
        }

        public static Set deserialize(Dynamic<?> dynamic) {
            String setName = dynamic.get("gem_set").asString("classic");
            return "light".equals(setName) ? LIGHT : ("dark".equals(setName) ? DARK : CLASSIC);
        }

        public MultiGemOreBlock getMultiOre() {
            return this.multiOre;
        }

        public IBlockProvider getGeodeShell() {
            return this.geodeShell;
        }

        public Gems selectRandom(Random random) {
            int id = random.nextInt(16) + this.startMeta;
            return Gems.values()[id];
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public ITextComponent getDisplayName() {
            TranslationTextComponent textSet = new TranslationTextComponent("gem.silentgems.set." + this.getName(), new Object[0]);
            return new TranslationTextComponent("gem.silentgems.set", new Object[]{textSet}).func_211708_a(TextFormatting.ITALIC);
        }

        @Override
        public Iterator<Gems> iterator() {
            return this.gems.iterator();
        }
    }
}

