/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import java.util.Locale;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.entity.AbstractWispEntity;
import net.silentchaos512.gems.entity.ChaosWispEntity;
import net.silentchaos512.gems.entity.FireWispEntity;
import net.silentchaos512.gems.entity.IceWispEntity;
import net.silentchaos512.gems.entity.LightningWispEntity;
import net.silentchaos512.gems.entity.WaterWispEntity;
import net.silentchaos512.gems.entity.projectile.AbstractWispShotEntity;
import net.silentchaos512.gems.entity.projectile.ChaosWispShotEntity;
import net.silentchaos512.gems.entity.projectile.FireWispShotEntity;
import net.silentchaos512.gems.entity.projectile.IceWispShotEntity;
import net.silentchaos512.gems.entity.projectile.LightningWispShotEntity;
import net.silentchaos512.gems.entity.projectile.WaterWispShotEntity;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.Lazy;

public enum WispTypes {
    CHAOS((EntityType.Builder<? extends AbstractWispEntity>)EntityType.Builder.func_220322_a(ChaosWispEntity::new, (EntityClassification)EntityClassification.MONSTER), (EntityType.Builder<? extends AbstractWispShotEntity>)EntityType.Builder.func_220322_a(ChaosWispShotEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new ChaosWispShotEntity((World)world)), Color.LAVENDER),
    FIRE((EntityType.Builder<? extends AbstractWispEntity>)EntityType.Builder.func_220322_a(FireWispEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c(), (EntityType.Builder<? extends AbstractWispShotEntity>)EntityType.Builder.func_220322_a(FireWispShotEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new FireWispShotEntity((World)world)), Color.ORANGERED),
    ICE((EntityType.Builder<? extends AbstractWispEntity>)EntityType.Builder.func_220322_a(IceWispEntity::new, (EntityClassification)EntityClassification.MONSTER), (EntityType.Builder<? extends AbstractWispShotEntity>)EntityType.Builder.func_220322_a(IceWispShotEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new IceWispShotEntity((World)world)), Color.CYAN),
    LIGHTNING((EntityType.Builder<? extends AbstractWispEntity>)EntityType.Builder.func_220322_a(LightningWispEntity::new, (EntityClassification)EntityClassification.MONSTER), (EntityType.Builder<? extends AbstractWispShotEntity>)EntityType.Builder.func_220322_a(LightningWispShotEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new LightningWispShotEntity((World)world)), Color.GOLD),
    WATER((EntityType.Builder<? extends AbstractWispEntity>)EntityType.Builder.func_220322_a(WaterWispEntity::new, (EntityClassification)EntityClassification.MONSTER), (EntityType.Builder<? extends AbstractWispShotEntity>)EntityType.Builder.func_220322_a(WaterWispShotEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new WaterWispShotEntity((World)world)), Color.DODGERBLUE);

    private final EntityType<? extends AbstractWispEntity> type;
    private final EntityType<? extends AbstractWispShotEntity> shotType;
    private final Lazy<SpawnEggItem> spawnEgg;
    private final Color color;

    private WispTypes(EntityType.Builder<? extends AbstractWispEntity> entityBuilder, EntityType.Builder<? extends AbstractWispShotEntity> shotBuilder, Color color) {
        this.type = entityBuilder.func_206830_a(SilentGems.getId(this.getName()).toString());
        this.shotType = shotBuilder.func_206830_a(SilentGems.getId(this.getName() + "_shot").toString());
        this.spawnEgg = Lazy.of(() -> {
            Item.Properties properties = new Item.Properties().func_200916_a(GemsItemGroups.UTILITY);
            return new SpawnEggItem(this.type, color.getColor(), Color.DARKVIOLET.getColor(), properties);
        });
        this.color = color;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_wisp";
    }

    public EntityType<? extends AbstractWispEntity> getEntityType() {
        return this.type;
    }

    public EntityType<? extends AbstractWispShotEntity> getShotType() {
        return this.shotType;
    }

    public SpawnEggItem getSpawnEgg() {
        return (SpawnEggItem)this.spawnEgg.get();
    }

    public Color getColor() {
        return this.color;
    }

    public static WispTypes selectRandom(Random random) {
        return WispTypes.values()[random.nextInt(WispTypes.values().length)];
    }
}

