/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.chaosbuff;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.chaosbuff.ChaosBuffSerializers;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.gems.network.Network;
import net.silentchaos512.gems.network.SyncChaosBuffsPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ChaosBuffManager
implements IResourceManagerReloadListener {
    public static final ChaosBuffManager INSTANCE = new ChaosBuffManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"ChaosBuffManager");
    private static final String DATA_PATH = "silentgems/chaos_buffs/";
    private static final Map<ResourceLocation, IChaosBuff> MAP = new LinkedHashMap<ResourceLocation, IChaosBuff>();

    private ChaosBuffManager() {
    }

    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        MAP.clear();
        SilentGems.LOGGER.info(MARKER, "Reloading chaos buff files");
        for (ResourceLocation id : resources) {
            try {
                IResource iresource = resourceManager.func_199002_a(id);
                Throwable throwable = null;
                try {
                    JsonObject json;
                    String path = id.func_110623_a().substring(DATA_PATH.length(), id.func_110623_a().length() - ".json".length());
                    ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                    if (SilentGems.LOGGER.isTraceEnabled()) {
                        SilentGems.LOGGER.trace(MARKER, "Found likely chaos buff file: {}, trying to read as {}", (Object)id, (Object)name);
                    }
                    if ((json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class)) == null) {
                        SilentGems.LOGGER.error(MARKER, "could not load chaos buff {} as it's null or empty", (Object)name);
                        continue;
                    }
                    ChaosBuffManager.addBuff(ChaosBuffSerializers.deserialize(name, json));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                SilentGems.LOGGER.error(MARKER, "Parsing error loading chaos buff {}", (Object)id, (Object)ex);
            }
            catch (IOException ex) {
                SilentGems.LOGGER.error(MARKER, "Could not read chaos buff {}", (Object)id, (Object)ex);
            }
        }
        SilentGems.LOGGER.info(MARKER, "Finished! Registered {} chaos buffs", (Object)MAP.size());
    }

    private static void addBuff(IChaosBuff buff) {
        if (MAP.containsKey(buff.getId())) {
            throw new IllegalArgumentException("Duplicate chaos buff " + buff.getId());
        }
        MAP.put(buff.getId(), buff);
    }

    @Nullable
    public static IChaosBuff get(ResourceLocation id) {
        return MAP.get(id);
    }

    @Nullable
    public static IChaosBuff get(String id) {
        return ChaosBuffManager.get(new ResourceLocation(id));
    }

    public static Collection<IChaosBuff> getValues() {
        return MAP.values();
    }

    public static void handlePacket(SyncChaosBuffsPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        packet.getBuffs().forEach(buff -> MAP.put(buff.getId(), (IChaosBuff)buff));
        SilentGems.LOGGER.info("Received {} chaos buffs from server", (Object)MAP.size());
    }

    @Mod.EventBusSubscriber(modid="silentgems")
    public static final class EventHandler {
        @SubscribeEvent
        public static void onPlayerJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                Collection<IChaosBuff> buffs = ChaosBuffManager.getValues();
                SilentGems.LOGGER.info("Sending {} chaos buffs to {}", (Object)buffs.size(), (Object)player.func_195047_I_());
                SyncChaosBuffsPacket message = new SyncChaosBuffsPacket(buffs);
                NetworkManager netManager = ((ServerPlayerEntity)player).field_71135_a.field_147371_a;
                Network.channel.sendTo((Object)message, netManager, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

