/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.chaosbuff;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;

public enum CostConditions {
    NO_CONDITION(p -> true),
    BURNING(Entity::func_70027_ad),
    FLYING(p -> p.field_71075_bZ.field_75100_b),
    HURT(p -> p.func_110143_aJ() < p.func_110138_aP() - 0.5f),
    IN_AIR(p -> !p.field_70122_E),
    MOVING(CostConditions::hasMoved),
    UNDERWATER(Entity::func_70090_H);

    private final Predicate<PlayerEntity> condition;

    private CostConditions(Predicate<PlayerEntity> condition) {
        this.condition = condition;
    }

    public boolean appliesTo(PlayerEntity player) {
        return this.condition.test(player);
    }

    @Nullable
    public static CostConditions from(String str) {
        for (CostConditions c : CostConditions.values()) {
            if (!c.name().equalsIgnoreCase(str)) continue;
            return c;
        }
        return null;
    }

    private static boolean hasMoved(PlayerEntity player) {
        return true;
    }
}

