/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.chaosbuff;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.chaosbuff.CostConditions;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuffSerializer;
import net.silentchaos512.utils.EnumUtils;

public class SimpleChaosBuff
implements IChaosBuff {
    static final Serializer<SimpleChaosBuff> SERIALIZER = new Serializer<SimpleChaosBuff>(Serializer.access$000(), SimpleChaosBuff::new);
    private final ResourceLocation id;
    Supplier<ITextComponent> displayName;
    int maxLevel;
    int[] slotsByLevel;
    int inactiveCost;
    int[] activeCostByLevel;
    CostConditions[] costConditions;

    public SimpleChaosBuff(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void applyTo(PlayerEntity player, int level) {
    }

    @Override
    public void removeFrom(PlayerEntity player) {
    }

    @Override
    public int getChaosGenerated(@Nullable PlayerEntity player, int level) {
        if (player != null && !this.isActive(player) || this.activeCostByLevel.length == 0) {
            return this.inactiveCost;
        }
        int clamp = MathHelper.func_76125_a((int)level, (int)0, (int)(this.activeCostByLevel.length - 1));
        return this.activeCostByLevel[clamp];
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getSlotsForLevel(int level) {
        if (this.slotsByLevel.length == 0) {
            return 0;
        }
        int clamp = MathHelper.func_76125_a((int)level, (int)0, (int)(this.slotsByLevel.length - 1));
        return this.slotsByLevel[clamp];
    }

    @Override
    public boolean isActive(PlayerEntity player) {
        for (CostConditions c : this.costConditions) {
            if (c == null || c.appliesTo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        if (level < 1) {
            return this.displayName.get();
        }
        return this.displayName.get().func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("enchantment.level." + level, new Object[0]));
    }

    @Override
    public int getRuneColor() {
        return 0xFFFFFF;
    }

    @Override
    public IChaosBuffSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static final class Serializer<T extends SimpleChaosBuff>
    implements IChaosBuffSerializer<T> {
        private static final ResourceLocation NAME = SilentGems.getId("simple");
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> factory;
        @Nullable
        private final BiConsumer<T, JsonObject> readJson;
        @Nullable
        private final BiConsumer<T, PacketBuffer> readBuffer;
        @Nullable
        private final BiConsumer<T, PacketBuffer> writeBuffer;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory) {
            this(serializerId, factory, null, null, null);
        }

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory, @Nullable BiConsumer<T, JsonObject> readJson, @Nullable BiConsumer<T, PacketBuffer> readBuffer, @Nullable BiConsumer<T, PacketBuffer> writeBuffer) {
            this.serializerId = serializerId;
            this.factory = factory;
            this.readJson = readJson;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            SimpleChaosBuff buff = (SimpleChaosBuff)this.factory.apply(id);
            buff.maxLevel = JSONUtils.func_151208_a((JsonObject)json, (String)"maxLevel", (int)1);
            buff.displayName = Serializer.readTextComponent(json, "displayName");
            this.readSlots(buff, json);
            this.readCost(buff, json.get("cost"));
            if (this.readJson != null) {
                this.readJson.accept(buff, json);
            }
            return (T)buff;
        }

        private void readSlots(T buff, JsonObject json) {
            JsonElement elem = json.get("slots");
            if (elem.isJsonArray()) {
                JsonArray array = elem.getAsJsonArray();
                ((SimpleChaosBuff)buff).slotsByLevel = new int[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    ((SimpleChaosBuff)buff).slotsByLevel[i] = array.get(i).getAsInt();
                }
            } else {
                ((SimpleChaosBuff)buff).slotsByLevel = new int[]{elem.getAsInt()};
            }
        }

        private void readCost(T buff, JsonElement jsonElement) {
            JsonElement elem1;
            if (!jsonElement.isJsonObject()) {
                throw new JsonParseException("Expected 'cost' to be an object");
            }
            JsonObject json = jsonElement.getAsJsonObject();
            ((SimpleChaosBuff)buff).inactiveCost = JSONUtils.func_151208_a((JsonObject)json, (String)"inactive", (int)0);
            JsonElement elem = json.get("active");
            if (elem == null) {
                throw new JsonParseException("Missing required element, 'cost.active' (should be array or int)");
            }
            if (elem.isJsonArray()) {
                JsonArray array = elem.getAsJsonArray();
                ((SimpleChaosBuff)buff).activeCostByLevel = new int[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    ((SimpleChaosBuff)buff).activeCostByLevel[i] = array.get(i).getAsInt();
                }
            } else {
                ((SimpleChaosBuff)buff).activeCostByLevel = new int[]{elem.getAsInt()};
            }
            if ((elem1 = json.get("conditions")) == null) {
                ((SimpleChaosBuff)buff).costConditions = new CostConditions[0];
            } else if (elem1.isJsonArray()) {
                JsonArray array = elem1.getAsJsonArray();
                ((SimpleChaosBuff)buff).costConditions = new CostConditions[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    String str = array.get(i).getAsString();
                    CostConditions condition = CostConditions.from(str);
                    if (condition == null) {
                        SilentGems.LOGGER.warn("Unknown chaos buff condition: {}", (Object)str);
                    }
                    ((SimpleChaosBuff)buff).costConditions[i] = condition;
                }
            } else {
                ((SimpleChaosBuff)buff).costConditions = new CostConditions[]{CostConditions.from(elem1.getAsString())};
            }
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            SimpleChaosBuff buff = (SimpleChaosBuff)this.factory.apply(id);
            ITextComponent displayName = buffer.func_179258_d();
            buff.displayName = () -> ((ITextComponent)displayName).func_212638_h();
            buff.maxLevel = buffer.readByte();
            buff.slotsByLevel = buffer.func_186863_b();
            buff.inactiveCost = buffer.func_150792_a();
            buff.activeCostByLevel = buffer.func_186863_b();
            buff.costConditions = new CostConditions[buffer.readByte()];
            for (int i = 0; i < buff.costConditions.length; ++i) {
                buff.costConditions[i] = (CostConditions)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)CostConditions.NO_CONDITION);
            }
            if (this.readBuffer != null) {
                this.readBuffer.accept(buff, buffer);
            }
            return (T)buff;
        }

        @Override
        public void write(PacketBuffer buffer, T buff) {
            buffer.func_179256_a(((SimpleChaosBuff)buff).displayName.get());
            buffer.writeByte(((SimpleChaosBuff)buff).maxLevel);
            buffer.func_186875_a(((SimpleChaosBuff)buff).slotsByLevel);
            buffer.func_150787_b(((SimpleChaosBuff)buff).inactiveCost);
            buffer.func_186875_a(((SimpleChaosBuff)buff).activeCostByLevel);
            buffer.writeByte(((SimpleChaosBuff)buff).costConditions.length);
            Arrays.stream(((SimpleChaosBuff)buff).costConditions).mapToInt(Enum::ordinal).forEach(arg_0 -> ((PacketBuffer)buffer).writeByte(arg_0));
            if (this.writeBuffer != null) {
                this.writeBuffer.accept(buff, buffer);
            }
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }

        private static Supplier<ITextComponent> readTextComponent(JsonObject json, String name) {
            JsonElement element = json.get(name);
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                boolean translate = JSONUtils.func_151209_a((JsonObject)obj, (String)"translate", (boolean)false);
                String value = JSONUtils.func_151200_h((JsonObject)obj, (String)"name");
                return translate ? () -> new TranslationTextComponent(value, new Object[0]) : () -> new StringTextComponent(value);
            }
            if (element != null) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            throw new JsonParseException("Missing required object '" + name + "'");
        }

        static /* synthetic */ ResourceLocation access$000() {
            return NAME;
        }
    }
}

