/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.lib.soul.SoulElement;
import net.silentchaos512.gems.lib.soul.SoulTraits;
import net.silentchaos512.gems.util.SoulManager;

public class GearSoul {
    public static final float XP_FACTOR_KILLS = 0.35f;
    public static final float XP_FACTOR_TILLING = 4.0f;
    public static final float XP_FACTOR_BLOCK_MINED = 1.0f;
    public static final float XP_FACTOR_ARMOR_DAMAGED = 3.0f;
    public static final int XP_MAX_PER_BLOCK = 20;
    public static final float XP_MIN_BLOCK_HARDNESS = 0.5f;
    private static final int BASE_XP = 30;
    private static final float XP_CURVE_FACTOR = 3.0f;
    String name = "";
    boolean readyToSave = false;
    private int xp = 0;
    private int level = 1;
    private SoulElement primaryElement = SoulElement.NONE;
    private SoulElement secondaryElement = SoulElement.NONE;
    private final Map<SoulTraits, Integer> skills = new HashMap<SoulTraits, Integer>();
    public int climbTimer = 0;
    public int coffeeCooldown = 0;
    private int ticksExisted = 0;

    public void addXp(int amount, ItemStack tool, PlayerEntity player) {
        if (!((Boolean)GemsConfig.COMMON.gearSoulsGetXpFromFakePlayers.get()).booleanValue() && player instanceof FakePlayer) {
            return;
        }
        this.xp += amount;
        boolean packetSent = false;
        while (this.xp >= this.getXpToNextLevel()) {
            SoulTraits skillLearned = this.levelUp(tool, player);
            if (skillLearned == null) continue;
            Integer skillLevel = this.getSkillLevel(skillLearned);
            this.sendUpdatePacket(tool, player, skillLearned, skillLevel);
            packetSent = true;
        }
        if (!packetSent) {
            this.sendUpdatePacket(tool, player, null, 0);
        }
    }

    public void setXp(int packetAmount) {
        this.xp = packetAmount;
    }

    public int getXpToNextLevel() {
        return GearSoul.getXpForLevel(this.level + 1);
    }

    public static int getXpForLevel(int target) {
        return 30 * (int)Math.pow(target, 3.0);
    }

    public void setLevel(int packetAmount) {
        this.level = packetAmount;
    }

    public ITextComponent getName(ItemStack tool) {
        if (this.name.isEmpty() && !tool.func_190926_b()) {
            return tool.func_200301_q();
        }
        return new StringTextComponent(this.name);
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    @Nullable
    private SoulTraits levelUp(ItemStack tool, PlayerEntity player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return null;
        }
        ++this.level;
        player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.levelUp", new Object[]{this.getName(tool), this.level}));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
        SoulTraits toLearn = SoulTraits.selectTraitToLearn(this, tool);
        if (toLearn != null) {
            this.addOrLevelSkill(toLearn, tool, player);
        }
        SoulManager.setSoul(tool, this);
        this.readyToSave = false;
        GearData.recalculateStats((ItemStack)tool, (PlayerEntity)player);
        return toLearn;
    }

    public int getXpForBlockHarvest(IBlockReader world, BlockPos pos, BlockState state) {
        float hardness = state.func_185887_b(world, pos);
        if (hardness < 0.5f) {
            return 0;
        }
        int oreBonus = 0;
        Block block = state.func_177230_c();
        if (BlockTags.field_200031_h.func_199685_a_((Object)block) || Tags.Blocks.ORES.func_199685_a_((Object)block)) {
            oreBonus = this.level / 2;
        }
        if (state.func_185904_a() == Material.field_151575_d) {
            hardness /= 2.0f;
        }
        int clamp = MathHelper.func_76125_a((int)Math.round(1.0f * hardness), (int)1, (int)20);
        return oreBonus + clamp;
    }

    public void onBreakBlock(PlayerEntity player, ItemStack gear, IBlockReader world, BlockPos pos, BlockState blockState) {
        int xp = this.getXpForBlockHarvest(world, pos, blockState);
        this.addXp(xp, gear, player);
    }

    public void onAttackedWith(PlayerEntity player, ItemStack gear, LivingEntity target, float damageAmount) {
        int xp = Math.round(0.35f * damageAmount);
        xp = MathHelper.func_76125_a((int)xp, (int)1, (int)1000);
        this.addXp(xp, gear, player);
    }

    public boolean addOrLevelSkill(SoulTraits skill, ItemStack tool, PlayerEntity player) {
        if (this.skills.containsKey(skill)) {
            int level = this.skills.get(skill);
            if (level < skill.getMaxLevel()) {
                this.skills.put(skill, ++level);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.skillLearned", new Object[]{skill.getDisplayName(level)}));
                return true;
            }
            return false;
        }
        this.skills.put(skill, 1);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.skillLearned", new Object[]{skill.getDisplayName(1)}));
        return true;
    }

    public void setSkillLevel(SoulTraits skill, int skillLevel, ItemStack tool, PlayerEntity player) {
        if (skillLevel <= 0) {
            this.skills.remove(skill);
        }
        this.skills.put(skill, skillLevel > skill.getMaxLevel() ? skill.getMaxLevel() : skillLevel);
    }

    public boolean hasSkill(SoulTraits skill) {
        return this.skills.containsKey(skill);
    }

    public int getSkillLevel(SoulTraits skill) {
        if (!this.hasSkill(skill)) {
            return 0;
        }
        return this.skills.get(skill);
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<ITextComponent> list, boolean advanced) {
        list.add(1, new TranslationTextComponent("misc.silentgems.gear_soul.level", new Object[]{String.valueOf(this.level), String.format("%,d", this.xp), String.format("%,d", this.getXpToNextLevel())}).func_211708_a(TextFormatting.GREEN));
        if (stack.func_77973_b() instanceof GearSoulItem) {
            list.add(2, this.getElementPairText());
        }
    }

    float getStatModifier(ItemStat stat) {
        String statName = stat.getName().func_110623_a();
        return this.primaryElement.getStatModifier(statName) + this.secondaryElement.getStatModifier(statName) / 2.0f;
    }

    private ITextComponent getElementPairText() {
        if (this.secondaryElement != SoulElement.NONE) {
            return new TranslationTextComponent("misc.silentgems.gear_soul.elements.pair", new Object[]{this.primaryElement.getDisplayName(), this.secondaryElement.getDisplayName()});
        }
        return new TranslationTextComponent("misc.silentgems.gear_soul.elements.single", new Object[]{this.primaryElement.getDisplayName()});
    }

    public static GearSoul construct(Iterable<Soul> souls) {
        EnumMap<SoulElement, Integer> elements = new EnumMap<SoulElement, Integer>(SoulElement.class);
        for (Soul soul : souls) {
            if (soul == null) {
                SilentGems.LOGGER.error("Got a null soul when constructing a gear soul", (Throwable)new NullPointerException("soul is null"));
                continue;
            }
            int current = elements.getOrDefault((Object)soul.getPrimaryElement(), 0);
            elements.put(soul.getPrimaryElement(), current + 5);
            if (soul.getSecondaryElement() == SoulElement.NONE) continue;
            current = elements.getOrDefault((Object)soul.getSecondaryElement(), 0);
            elements.put(soul.getSecondaryElement(), current + 3);
        }
        GearSoul toolSoul = new GearSoul();
        toolSoul.primaryElement = GearSoul.selectHighestWeight(elements);
        elements.remove((Object)toolSoul.primaryElement);
        if (!elements.isEmpty()) {
            toolSoul.secondaryElement = GearSoul.selectHighestWeight(elements);
        }
        return toolSoul;
    }

    public static GearSoul randomSoul() {
        GearSoul soul = new GearSoul();
        ArrayList<SoulElement> elements = new ArrayList<SoulElement>();
        for (SoulElement elem : SoulElement.values()) {
            if (elem == SoulElement.NONE) continue;
            elements.add(elem);
        }
        soul.primaryElement = (SoulElement)((Object)elements.get(SilentGems.random.nextInt(elements.size())));
        elements.remove((Object)soul.primaryElement);
        elements.add(SoulElement.NONE);
        soul.secondaryElement = (SoulElement)((Object)elements.get(SilentGems.random.nextInt(elements.size())));
        return soul;
    }

    private static SoulElement selectHighestWeight(Map<SoulElement, Integer> elements) {
        SoulElement element = SoulElement.NONE;
        int highestWeight = 0;
        for (Map.Entry<SoulElement, Integer> entry : elements.entrySet()) {
            SoulElement elementInMap = entry.getKey();
            int weightInMap = entry.getValue();
            if (weightInMap <= highestWeight && (weightInMap != highestWeight || elementInMap.weight <= element.weight)) continue;
            element = entry.getKey();
            highestWeight = entry.getValue();
        }
        return element;
    }

    public void updateTick(ItemStack tool, PlayerEntity player) {
        boolean inMainHand;
        if (!player.field_70170_p.field_72995_K) {
            ++this.ticksExisted;
            if (this.coffeeCooldown > 0) {
                --this.coffeeCooldown;
            }
        }
        boolean bl = inMainHand = player.func_184614_ca() == tool;
        if (this.readyToSave && !inMainHand) {
            this.readyToSave = false;
            SoulManager.setSoul(tool, this);
        }
    }

    public boolean isReadyToSave() {
        return this.readyToSave;
    }

    public void setReadyToSave(boolean value) {
        this.readyToSave = value;
    }

    public static GearSoul read(CompoundNBT tags) {
        GearSoul soul = new GearSoul();
        soul.name = tags.func_74779_i("name");
        soul.primaryElement = SoulElement.fromString(tags.func_74779_i("element1"));
        soul.secondaryElement = SoulElement.fromString(tags.func_74779_i("element2"));
        soul.xp = tags.func_74762_e("xp");
        soul.level = tags.func_74762_e("level");
        soul.skills.clear();
        ListNBT tagList = tags.func_150295_c("skills", 10);
        for (INBT nbt : tagList) {
            CompoundNBT tag;
            SoulTraits skill;
            if (!(nbt instanceof CompoundNBT) || (skill = SoulTraits.get((tag = (CompoundNBT)nbt).func_74779_i("id"))) == null) continue;
            short level = tag.func_74765_d("level");
            soul.skills.put(skill, Integer.valueOf(level));
        }
        return soul;
    }

    public void write(CompoundNBT tags) {
        if (!this.name.isEmpty()) {
            tags.func_74778_a("name", this.name);
        }
        tags.func_74778_a("element1", this.primaryElement.name());
        tags.func_74778_a("element2", this.secondaryElement.name());
        tags.func_74768_a("xp", this.xp);
        tags.func_74768_a("level", this.level);
        ListNBT tagList = new ListNBT();
        this.skills.forEach((trait, level) -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("id", trait.getTraitId().toString());
            tag.func_74777_a("level", level.shortValue());
            tagList.add((Object)tag);
        });
        tags.func_218657_a("skills", (INBT)tagList);
    }

    public String toString() {
        return "GearSoul{Level: " + this.level + ", XP: " + this.xp + ", Elements: {" + this.primaryElement.name() + ", " + this.secondaryElement.name() + "}}";
    }

    private void sendUpdatePacket(ItemStack tool, PlayerEntity player, @Nullable SoulTraits skillLearned, int skillLevel) {
    }

    public int getXp() {
        return this.xp;
    }

    public int getLevel() {
        return this.level;
    }

    public SoulElement getPrimaryElement() {
        return this.primaryElement;
    }

    public SoulElement getSecondaryElement() {
        return this.secondaryElement;
    }

    public Map<SoulTraits, Integer> getSkills() {
        return this.skills;
    }
}

