/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.soul.GearSoul;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.utils.MathUtils;

public class GearSoulPart
extends AbstractGearPart
implements IUpgradePart {
    private static final ResourceLocation TYPE_ID = SilentGems.getId("gear_soul");
    public static final PartType TYPE = PartType.create((ResourceLocation)TYPE_ID, (String)"S", (IPartSerializer)new AbstractGearPart.Serializer(TYPE_ID, GearSoulPart::new));
    private static final IPartPosition POSITION = new IPartPosition(){

        public String getTexturePrefix() {
            return "soul";
        }

        public String getModelIndex() {
            return "soul";
        }
    };

    public GearSoulPart(ResourceLocation id) {
        super(id);
    }

    public PartType getType() {
        return TYPE;
    }

    public IPartPosition getPartPosition() {
        return POSITION;
    }

    public IPartSerializer<?> getSerializer() {
        return TYPE.getSerializer();
    }

    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartData part) {
        float amount;
        Collection mods = super.getStatModifiers(gear, stat, part);
        GearSoul soul = SoulManager.getSoul(!gear.func_190926_b() ? gear : part.getCraftingItem());
        if (soul != null && !MathUtils.doublesEqual((double)(amount = GearSoulPart.getSoulStatModifier(soul, stat)), (double)0.0)) {
            mods.add(GearSoulPart.getSoulBoostedModifier(stat, amount));
        }
        return mods;
    }

    private static float getSoulStatModifier(GearSoul soul, ItemStat stat) {
        return soul.getStatModifier(stat);
    }

    private static StatInstance getSoulBoostedModifier(ItemStat stat, float value) {
        return new StatInstance("silentgems:soul/" + stat.getName().func_110623_a(), value, StatInstance.Operation.MUL1);
    }

    public List<PartTraitInstance> getTraits(ItemStack gear, PartData part) {
        ArrayList<PartTraitInstance> traits = new ArrayList<PartTraitInstance>(super.getTraits(gear, part));
        GearSoul soul = SoulManager.getSoul(gear);
        if (soul != null) {
            soul.getSkills().forEach((skill, level) -> {
                if (skill.getTrait() != null) {
                    traits.add(new PartTraitInstance(skill.getTrait(), level.intValue(), (Collection)ImmutableList.of()));
                }
            });
        }
        return traits;
    }

    public void onAddToGear(ItemStack gear, ItemStack part) {
        GearSoul soul = SoulManager.getSoul(part);
        if (soul == null) {
            SilentGems.LOGGER.warn("Gear soul is missing soul data: {}", (Object)part);
            return;
        }
        SoulManager.setSoul(gear, soul);
    }
}

