/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.utils.EnumUtils;
import net.silentchaos512.utils.MathUtils;

public enum SoulElement {
    NONE(Builder.create(1, 0xFFFFFF, TextFormatting.ITALIC)),
    FIRE(Builder.create(13, 16026690, TextFormatting.RED).modifier("melee_damage", 0.15f).modifier("ranged_damage", 0.1f).modifier("ranged_speed", -0.05f).modifier("armor", -0.05f)),
    WATER(Builder.create(12, 4295156, TextFormatting.BLUE).modifier("melee_damage", -0.1f).modifier("magic_damage", 0.15f).modifier("ranged_speed", 0.1f)),
    EARTH(Builder.create(11, 2081057, TextFormatting.DARK_GREEN).modifier("durability", 0.15f).modifier("armor_durability", 0.1f).modifier("magic_damage", -0.05f).modifier("ranged_speed", -0.1f)),
    WIND(Builder.create(10, 8648641, TextFormatting.AQUA).modifier("repair_efficiency", 0.05f).modifier("harvest_speed", 0.15f).modifier("melee_damage", -0.1f).modifier("ranged_speed", 0.15f)),
    METAL(Builder.create(18, 0xAAAAAA, TextFormatting.GRAY).modifier("durability", 0.2f).modifier("armor_durability", 0.2f).modifier("repair_efficiency", -0.1f).modifier("magic_damage", -0.1f).modifier("armor", 0.1f)),
    ICE(Builder.create(17, 9371628, TextFormatting.DARK_AQUA).modifier("durability", -0.05f).modifier("armor_durability", -0.1f).modifier("magic_damage", 0.2f).modifier("armor", -0.05f)),
    LIGHTNING(Builder.create(16, 0xFFFF47, TextFormatting.YELLOW).modifier("durability", -0.1f).modifier("armor_durability", -0.05f).modifier("harvest_speed", 0.1f).modifier("melee_damage", 0.1f).modifier("magic_damage", 0.05f).modifier("armor", -0.1f)),
    VENOM(Builder.create(15, 8634701, TextFormatting.LIGHT_PURPLE).modifier("durability", 0.1f).modifier("harvest_speed", -0.15f).modifier("melee_damage", 0.15f).modifier("ranged_damage", 0.1f)),
    FLORA(Builder.create(5, 2587695, TextFormatting.GREEN).modifier("durability", -0.05f).modifier("armor_durability", 0.05f).modifier("repair_efficiency", 0.1f).modifier("melee_damage", -0.1f).modifier("magic_damage", 0.1f)),
    FAUNA(Builder.create(6, 16753623, TextFormatting.DARK_RED).modifier("melee_damage", 0.1f).modifier("magic_damage", -0.1f).modifier("ranged_speed", 0.05f).modifier("armor", -0.05f)),
    MONSTER(Builder.create(7, 6509880, TextFormatting.DARK_BLUE).modifier("durability", 0.1f).modifier("repair_efficiency", -0.05f).modifier("harvest_speed", -0.05f).modifier("magic_damage", -0.1f).modifier("ranged_damage", 0.1f)),
    ALIEN(Builder.create(8, 9323173, TextFormatting.DARK_PURPLE).modifier("repair_efficiency", -0.05f).modifier("harvest_speed", -0.1f).modifier("magic_damage", 0.15f).modifier("ranged_speed", 0.15f).modifier("armor", 0.05f));

    public final int weight;
    public final int color;
    public final TextFormatting textColor;
    private final Map<String, Float> modifiers;

    private SoulElement(Builder builder) {
        this.weight = builder.weight;
        this.color = builder.color;
        this.textColor = builder.textColor;
        this.modifiers = builder.modifiers;
    }

    public float getStatModifier(String stat) {
        return this.modifiers.getOrDefault(stat, Float.valueOf(0.0f)).floatValue();
    }

    public ITextComponent getDisplayName() {
        String translationKey = "soul.silentgems.element." + this.name().toLowerCase(Locale.ROOT);
        return new TranslationTextComponent(translationKey, new Object[0]).func_211708_a(this.textColor);
    }

    public static SoulElement selectRandom(Random random) {
        return SoulElement.selectRandom(random, 0.0f);
    }

    public static SoulElement selectRandom(Random random, float chanceOfNone) {
        if (MathUtils.tryPercentage((Random)random, (double)chanceOfNone)) {
            return NONE;
        }
        return SoulElement.values()[MathUtils.nextIntInclusive((Random)random, (int)1, (int)(SoulElement.values().length - 1))];
    }

    public static SoulElement fromString(String str) {
        for (SoulElement element : SoulElement.values()) {
            if (!element.name().equalsIgnoreCase(str)) continue;
            return element;
        }
        return NONE;
    }

    public static SoulElement read(PacketBuffer buffer) {
        return (SoulElement)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)NONE);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeByte(this.ordinal());
    }

    private static class Builder {
        private static final String DURABILITY = "durability";
        private static final String ARMOR_DURABILITY = "armor_durability";
        private static final String REPAIR_EFFICIENCY = "repair_efficiency";
        private static final String HARVEST_SPEED = "harvest_speed";
        private static final String MELEE_DAMAGE = "melee_damage";
        private static final String MAGIC_DAMAGE = "magic_damage";
        private static final String RANGED_DAMAGE = "ranged_damage";
        private static final String RANGED_SPEED = "ranged_speed";
        private static final String ARMOR = "armor";
        final int weight;
        final int color;
        final TextFormatting textColor;
        final Map<String, Float> modifiers = new LinkedHashMap<String, Float>();

        private Builder(int weight, int color, TextFormatting textColor) {
            this.weight = weight;
            this.color = color;
            this.textColor = textColor;
        }

        static Builder create(int weight, int color, TextFormatting textColor) {
            return new Builder(weight, color, textColor);
        }

        Builder modifier(String stat, float value) {
            this.modifiers.put(stat, Float.valueOf(value));
            return this;
        }
    }
}

