/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.soul.Soul;

public class SetSoulFunction
implements ILootFunction {
    public static final Serializer SERIALIZER = new Serializer(SilentGems.getId("set_soul"), SetSoulFunction.class);
    private final String soulId;

    public SetSoulFunction(String soulId) {
        this.soulId = soulId;
    }

    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        ItemStack result = itemStack.func_77946_l();
        Soul soul = Soul.from(this.soulId);
        if (soul != null) {
            SoulGemItem.setSoul(result, soul);
        }
        return result;
    }

    public static ILootFunction.IBuilder builder(Soul soul) {
        return () -> new SetSoulFunction(soul.getId().toString());
    }

    public static class Serializer
    extends ILootFunction.Serializer<SetSoulFunction> {
        protected Serializer(ResourceLocation location, Class<SetSoulFunction> clazz) {
            super(location, clazz);
        }

        public void serialize(JsonObject json, SetSoulFunction value, JsonSerializationContext serializationContext) {
            json.addProperty("soul", value.soulId);
        }

        public SetSoulFunction deserialize(JsonObject json, JsonDeserializationContext context) {
            String soulId = JSONUtils.func_151200_h((JsonObject)json, (String)"soul");
            return new SetSoulFunction(soulId);
        }
    }
}

