/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.potion;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.math.AxisAlignedBB;
import net.silentchaos512.gems.init.GemsEffects;
import net.silentchaos512.gems.util.ModDamageSource;

public class ShockingEffect
extends Effect {
    private static final int CONTINUOUS_DAMAGE_DELAY = 15;
    private static final int CONTINUOUS_DAMAGE_AMOUNT = 1;
    private static final int CHAIN_DELAY = 5;
    private static final int CHAIN_DISTANCE = 3;
    public static final UUID MOD_UUID = UUID.fromString("966ce179-1967-4b80-b894-bc743f1edbef");
    public static final String MOD_NAME = "silentgems:shocking_weakness";
    public static boolean CONTINUOUS_DAMAGE_ENABLED = true;
    public static boolean CHAINING_ENABLED = true;
    private final AttributeModifier modifier = new AttributeModifier(MOD_UUID, "silentgems:shocking_weakness", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public ShockingEffect() {
        super(EffectType.HARMFUL, 16121661);
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        EffectInstance effect = entity.func_70660_b((Effect)this);
        if (effect == null) {
            return;
        }
        int shockTimer = effect.func_76459_b();
        this.tryChaining(entity, shockTimer, amplifier);
        if (!entity.field_70170_p.field_72995_K && CONTINUOUS_DAMAGE_ENABLED && !ShockingEffect.isGrounded(entity) && (shockTimer + entity.func_145782_y()) % 15 == 0) {
            entity.func_70097_a(ModDamageSource.SHOCKING, 1.0f);
        }
    }

    private void tryChaining(LivingEntity source, int sourceDuration, int amplifier) {
        if (source.field_70170_p.field_72995_K || !CHAINING_ENABLED) {
            return;
        }
        int halfTime = sourceDuration / 2;
        if (sourceDuration % 5 == 0 && halfTime > 0) {
            for (LivingEntity target : ShockingEffect.getChainableEntities(source)) {
                EffectInstance effect = target.func_70660_b((Effect)this);
                if (effect != null) continue;
                target.func_195064_c(new EffectInstance((Effect)this, halfTime, 0, true, false));
            }
        }
    }

    private static List<LivingEntity> getChainableEntities(LivingEntity source) {
        AxisAlignedBB box = new AxisAlignedBB(source.func_180425_c().func_177982_a(-3, -3, -3), source.func_180425_c().func_177982_a(3, 3, 3));
        return source.field_70170_p.func_175647_a(LivingEntity.class, box, e1 -> e1 != source && !(e1 instanceof PlayerEntity));
    }

    private static boolean isGrounded(LivingEntity entity) {
        return entity.func_70660_b(GemsEffects.grounded) != null;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_111185_a(LivingEntity entity, AbstractAttributeMap attributeMap, int amplifier) {
        if (ShockingEffect.isGrounded(entity)) {
            return;
        }
        IAttributeInstance iattributeinstance = attributeMap.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (iattributeinstance != null) {
            double amount = this.modifier.func_111164_d() * (double)(amplifier + 1);
            if (entity instanceof PlayerEntity) {
                amount /= 2.0;
            }
            iattributeinstance.func_111124_b(this.modifier);
            iattributeinstance.func_111121_a(new AttributeModifier(this.modifier.func_111167_a(), this.func_76393_a() + " " + amplifier, amount, this.modifier.func_220375_c()));
        }
    }

    public void func_111187_a(LivingEntity entity, AbstractAttributeMap attributeMap, int amplifier) {
        IAttributeInstance iattributeinstance = attributeMap.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (iattributeinstance != null) {
            iattributeinstance.func_111124_b(this.modifier);
        }
    }
}

