/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class ResourceManagerBase<T>
implements IResourceManagerReloadListener {
    private final String dataPath;
    private final Marker logMarker;
    private final Logger logger;
    protected final Map<ResourceLocation, T> resources = new LinkedHashMap<ResourceLocation, T>();

    protected ResourceManagerBase(String dataPath, String logMarker, Logger logger) {
        this.dataPath = dataPath;
        this.logMarker = MarkerManager.getMarker((String)logMarker);
        this.logger = logger;
    }

    public abstract T deserialize(ResourceLocation var1, JsonObject var2);

    @Nullable
    public T get(ResourceLocation id) {
        return this.resources.get(id);
    }

    public Collection<T> getValues() {
        return this.resources.values();
    }

    protected Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    protected Collection<ResourceLocation> getAllResources(IResourceManager resourceManager) {
        return resourceManager.func_199003_a(this.dataPath, s -> s.endsWith(".json"));
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        Gson gson = this.getGson();
        Collection<ResourceLocation> resourceLocations = this.getAllResources(resourceManager);
        if (resourceLocations.isEmpty()) {
            return;
        }
        this.resources.clear();
        for (ResourceLocation id : resourceLocations) {
            try {
                IResource iResource = resourceManager.func_199002_a(id);
                Throwable throwable = null;
                try {
                    int substringStart = this.dataPath.length();
                    int substringEnd = id.func_110623_a().length() - ".json".length();
                    String path = id.func_110623_a().substring(substringStart, substringEnd);
                    ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                    this.logger.debug(this.logMarker, "Found resource file '{}', reading as '{}'", (Object)id, (Object)name);
                    JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (json == null) {
                        this.logger.error(this.logMarker, "Could not load resource '{}' as it's null or empty", (Object)name);
                        continue;
                    }
                    T obj = this.deserialize(name, json);
                    this.addObject(name, obj);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iResource == null) continue;
                    if (throwable != null) {
                        try {
                            iResource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iResource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                this.logger.error(this.logMarker, "Parsing error loading '{}'", (Object)id);
                this.logger.catching(ex);
            }
            catch (IOException ex) {
                this.logger.error(this.logMarker, "Could not read file '{}'", (Object)id);
                this.logger.catching((Throwable)ex);
            }
        }
        this.logger.info(this.logMarker, "Registered {} objects", (Object)this.resources.size());
    }

    private void addObject(ResourceLocation id, T obj) {
        if (this.resources.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate object with ID " + id);
        }
        this.resources.put(id, obj);
    }
}

