/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.gems.init.GemsEnchantments;
import net.silentchaos512.gems.lib.soul.GearSoul;
import net.silentchaos512.gems.lib.soul.SoulTraits;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.lib.util.TimeUtils;

public final class SoulEvents {
    public static final SoulEvents INSTANCE = new SoulEvents();
    private static final int CLEAR_DELAY = TimeUtils.ticksFromMinutes((float)15.0f);
    private static final int SOUL_WRITE_DELAY = TimeUtils.ticksFromSeconds((float)30.0f);
    private static int ticks;

    private SoulEvents() {
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        ItemStack mainHand;
        GearSoul soul;
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && (soul = SoulManager.getSoul(mainHand = player.func_184614_ca())) != null) {
            soul.onBreakBlock(player, mainHand, (IBlockReader)event.getWorld(), event.getPos(), event.getState());
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack mainHand = player.func_184614_ca();
        if (EnchantmentHelper.func_77506_a((Enchantment)GemsEnchantments.gravity, (ItemStack)mainHand) > 0) {
            return;
        }
        GearSoul soul = SoulManager.getSoul(mainHand);
        if (soul != null) {
            int aerial;
            if (player.func_70090_H()) {
                int aquatic = TraitHelper.getTraitLevel((ItemStack)mainHand, (ResourceLocation)SoulTraits.AQUATIC);
                if (aquatic > 0) {
                    event.setNewSpeed(event.getNewSpeed() * (5.0f / (float)(5 - aquatic + 1)));
                }
            } else if ((!player.field_70122_E || player.field_71075_bZ.field_75100_b) && (aerial = TraitHelper.getTraitLevel((ItemStack)mainHand, (ResourceLocation)SoulTraits.AERIAL)) > 0) {
                event.setNewSpeed(event.getNewSpeed() * (5.0f / (float)(5 - aerial + 1)));
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
            LivingEntity hurt = event.getEntityLiving();
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack mainHand = player.func_184614_ca();
            GearSoul soul = SoulManager.getSoul(mainHand);
            if (soul != null) {
                float damageAmount = Math.min(event.getAmount(), hurt.func_110138_aP());
                soul.onAttackedWith(player, mainHand, hurt, damageAmount);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDamage(LivingHurtEvent event) {
        if (event.getSource() == DamageSource.field_76379_h && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            SoulTraits.getHighestLevelEitherHand(player, SoulTraits.AERIAL).ifPresent(hand -> {
                ItemStack stack = player.func_184586_b(hand);
                int level = TraitHelper.getTraitLevel((ItemStack)stack, (ResourceLocation)SoulTraits.AERIAL);
                float amountToReduce = Math.max((float)(2 + 2 * level), 0.15f * (float)level * event.getAmount());
                event.setAmount(event.getAmount() - amountToReduce);
                GearHelper.attemptDamage((ItemStack)stack, (int)2, (LivingEntity)player, (Hand)hand);
            });
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        SoulManager.writeSoulsToNBT(event.getPlayer(), true);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K && player.func_70086_ai() < 5) {
            SoulTraits.getHighestLevelEitherHand(player, SoulTraits.AQUATIC).ifPresent(hand -> {
                ItemStack stack = player.func_184586_b(hand);
                int level = TraitHelper.getTraitLevel((ItemStack)stack, (ResourceLocation)SoulTraits.AQUATIC);
                int amountToRestore = 60 * level;
                player.func_70050_g(player.func_70086_ai() + amountToRestore);
                GearHelper.attemptDamage((ItemStack)stack, (int)2, (LivingEntity)player, (Hand)hand);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_193805_fG, SoundCategory.PLAYERS, 1.0f, 1.0f);
            });
        }
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % SOUL_WRITE_DELAY == 0) {
            SoulManager.queueSoulsForWrite(player);
            SoulManager.writeSoulsToNBT(player, false);
        }
        for (ItemStack stack2 : PlayerUtils.getNonEmptyStacks((PlayerEntity)player, stack -> stack.func_77973_b() instanceof ICoreItem)) {
            GearSoul soul = SoulManager.getSoul(stack2);
            if (soul == null) continue;
            soul.updateTick(stack2, player);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (event.phase == TickEvent.Phase.END && (event instanceof TickEvent.ClientTickEvent || event instanceof TickEvent.ServerTickEvent) && ++ticks % CLEAR_DELAY == 0) {
            SoulManager.SOULS.clear();
        }
    }

    public static final class Client {
        public static final Client INSTANCE = new Client();

        private Client() {
        }

        @SubscribeEvent
        public void onTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            GearSoul soul = SoulManager.getSoul(stack);
            if (soul != null) {
                soul.addInformation(stack, null, event.getToolTip(), event.getFlags().func_194127_a());
            }
        }
    }
}

